/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.uas.roam.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xdja.uas.app.service.AppService;
import com.xdja.uas.common.util.HttpRequestUtil;
import com.xdja.uas.common.util.Page;
import com.xdja.uas.common.util.Util;
import com.xdja.uas.empower.entity.AppUseArea;
import com.xdja.uas.empower.entity.AppUseAreaTmp;
import com.xdja.uas.empower.entity.RoamTmpAppUseArea;
import com.xdja.uas.empower.service.EmpowerService;
import com.xdja.uas.roam.bean.InterfaceInfo;
import com.xdja.uas.roam.bean.PersonBean;
import com.xdja.uas.roam.bean.UserAppPower;
import com.xdja.uas.roam.bean.UserListOfAppResBean;
import com.xdja.uas.roam.dao.RoamAppAuthDao;
import com.xdja.uas.roam.entity.RoamAppUseArea;
import com.xdja.uas.roam.exception.RoamException;
import com.xdja.uas.roam.service.AuthUserAppService;
import com.xdja.uas.roam.service.SodService;
import com.xdja.uas.syms.service.SystemConfigService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class AuthUserAppServiceImpl
implements AuthUserAppService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthUserAppServiceImpl.class);
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private EmpowerService empowerService;
    @Autowired
    private AppService appService;
    @Autowired
    private RoamAppAuthDao roamAppAuthDao;
    @Autowired
    private RoamAppAuthDao appAuthDao;
    @Autowired
    private SodService sodService;

    @Override
    @Transactional
    public void applyAppPower(List<UserAppPower> appPowerList) throws RoamException {
        ArrayList<UserAppPower> list;
        String localRegionalismCode = this.systemConfigService.getValueByCode("regionalismCode");
        HashMap<String, ArrayList<UserAppPower>> groupMap = new HashMap<String, ArrayList<UserAppPower>>();
        for (UserAppPower userAppPower : appPowerList) {
            if (groupMap.containsKey(userAppPower.getAppRegionalismCode())) {
                ((List)groupMap.get(userAppPower.getAppRegionalismCode())).add(userAppPower);
                continue;
            }
            list = new ArrayList<UserAppPower>();
            list.add(userAppPower);
            groupMap.put(userAppPower.getAppRegionalismCode(), list);
        }
        for (String appRegion : groupMap.keySet()) {
            list = (List)groupMap.get(appRegion);
            this.handleAppPower(list);
            if (localRegionalismCode.equals(appRegion)) continue;
            this.roamAppAuth(list);
        }
    }

    private void handleAppPower(List<UserAppPower> list) throws RoamException {
        for (UserAppPower userAppPower : list) {
            RoamAppUseArea roamAppUseArea = this.appAuthDao.query(userAppPower.getAppId(), userAppPower.getAppRegionalismCode(), userAppPower.getPersonId(), userAppPower.getPersonRegionalismCode());
            if ("1".equals(userAppPower.getType())) {
                if (roamAppUseArea != null) continue;
                RoamAppUseArea appUseArea = new RoamAppUseArea();
                appUseArea.setAppId(userAppPower.getAppId());
                appUseArea.setAppRegionalismCode(userAppPower.getAppRegionalismCode());
                appUseArea.setAreaId(userAppPower.getPersonId());
                appUseArea.setAreaRegionalismCode(userAppPower.getPersonRegionalismCode());
                appUseArea.setType("person");
                this.appAuthDao.addRoamAppUserAreaEntity(appUseArea);
                continue;
            }
            if ("2".equals(userAppPower.getType())) continue;
            if ("3".equals(userAppPower.getType())) {
                if (roamAppUseArea == null) continue;
                this.appAuthDao.delete(roamAppUseArea);
                continue;
            }
            throw new RoamException("20004", "unsupport power operate type");
        }
    }

    private void roamAppAuth(List<UserAppPower> list) throws RoamException {
        String message;
        String resultCode;
        try {
            InterfaceInfo interfaceInfo = this.sodService.queryRegionalInterface(list.get(0).getAppRegionalismCode(), "IF-UPM-SVC-04");
            if (interfaceInfo == null) {
                throw new RoamException("20004", "to sod get offsite uas address return null");
            }
            String address = interfaceInfo.getInterfaceUrl();
            HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
            HashMap<String, String> headers = new HashMap<String, String>();
            String messageId = Util.getUUID();
            headers.put("messageId", messageId);
            String localRegionalismCode = this.systemConfigService.getValueByCode("regionalismCode");
            headers.put("appCredential", Util.getLocalAppCredential((String)localRegionalismCode));
            String param = JSON.toJSONString(list);
            LOGGER.debug("\u524d\u5f80\u5f02\u5730\u7edf\u4e00\u6388\u6743\u53cd\u9988\u53c2\u6570\uff1a{}", (Object)param);
            Map result = httpRequestUtil.httpPostJsonRet(address, param, headers);
            resultCode = (String)result.get("code");
            message = (String)result.get("message");
            LOGGER.debug("\u524d\u5f80\u5f02\u5730\u7edf\u4e00\u6388\u6743\u53cd\u9988\u7ed3\u679c\uff1acode\uff1a{}\uff0cmessage\uff1a{}", (Object)resultCode, (Object)message);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        if (!"0".equals(resultCode)) {
            throw new RoamException(resultCode, "[offsite]" + message);
        }
    }

    @Override
    public boolean authPersonAppPower(String userId, String personRegionalismCode, String appId, String appRegionalismCode, String appNetworkCode, String appPackage, String userCredential) throws RoamException {
        LOGGER.debug("------>\u5f00\u59cb\u6821\u9a8c\u7528\u6237\u5e94\u7528\u6743\u9650......");
        String localRegionalismCode = this.systemConfigService.getValueByCode("regionalismCode");
        if (StringUtils.isBlank((CharSequence)localRegionalismCode)) {
            throw new RoamException("20004", "\u7cfb\u7edf\u672a\u914d\u7f6e\u672c\u5730\u884c\u653f\u533a\u57df\u7f16\u7801");
        }
        HashSet<String> limitsTmp = new HashSet<String>();
        if (localRegionalismCode.equals(personRegionalismCode) && localRegionalismCode.equals(appRegionalismCode)) {
            LOGGER.debug("------>\u672c\u5730\u4eba\u5458\u672c\u5730\u5e94\u7528......");
            List list = this.empowerService.queryAppUseAreaByPersonId(userId);
            List listTmp = this.empowerService.queryAppUseAreaTmpByPersonId(userId);
            Set defaultLimits = this.empowerService.queryDefaultLimits();
            HashSet<String> limits = new HashSet<String>(defaultLimits);
            for (AppUseArea area : list) {
                limits.add(area.getAppId());
            }
            for (AppUseAreaTmp areaTmp : listTmp) {
                limitsTmp.add(areaTmp.getAppId());
            }
            limits.addAll(limitsTmp);
            if (!limits.contains(appId)) {
                LOGGER.warn("------>\u672c\u5730\u6743\u9650\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u672a\u67e5\u8be2\u5230\u6743\u9650\u4fe1\u606fappId:{},appRegionalismCode:{},personId:{},personRegionalismCode:{}", new Object[]{appId, appRegionalismCode, userId, personRegionalismCode});
                return false;
            }
        } else {
            LOGGER.debug("------>\u5f00\u59cb\u6821\u9a8c\u5f02\u5730\u4eba\u5458\u5e94\u7528\u6743\u9650\u4fe1\u606f......");
            RoamAppUseArea roamAppUseArea = this.roamAppAuthDao.checkAuth(userId, personRegionalismCode, appId, appRegionalismCode);
            if (roamAppUseArea == null) {
                LOGGER.warn("------>\u5f02\u5730\u6743\u9650\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u672a\u67e5\u8be2\u5230\u6743\u9650\u4fe1\u606fappId:{},appRegionalismCode:{},personId:{},personRegionalismCode:{}", new Object[]{appId, appRegionalismCode, userId, personRegionalismCode});
                return false;
            }
        }
        if (!limitsTmp.contains(appId)) {
            try {
                LOGGER.debug("------>\u6743\u9650\u6821\u9a8c\u901a\u8fc7\uff0c\u6b63\u5f0f\u6743\u9650\u9700\u8981\u68c0\u67e5\u5305\u540d\uff0c\u524d\u5f80\u5e94\u7528\u5e02\u573a\u67e5\u8be2\u5e94\u7528\u8be6\u60c5......");
                JSONObject appInfo = this.sodService.queryAppInfo(appId, appRegionalismCode, userCredential);
                if (appInfo != null) {
                    String appType = appInfo.getString("appType");
                    String appPackageName = appInfo.getString("appPackage");
                    if (StringUtils.isNotBlank((CharSequence)appPackage) && "1".equals(appType) && !appPackage.equals(appPackageName)) {
                        LOGGER.warn("------>\u5305\u540d\u4e0d\u7b26\uff0c\u4f20\u9012\u8fc7\u6765\u7684\u5305\u540d\uff1a{}\uff0c\u5e93\u4e2d\u5305\u540d\uff1a{}......", (Object)appPackage, (Object)appPackageName);
                        return false;
                    }
                    return true;
                }
            }
            catch (Exception e) {
                LOGGER.error("------>\u67e5\u8be2\u5e94\u7528\u8be6\u60c5\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
            }
        } else {
            LOGGER.debug("------>\u6743\u9650\u6821\u9a8c\u901a\u8fc7\uff0c\u4e34\u65f6\u6743\u9650\u8df3\u8fc7\u68c0\u67e5\u5305\u540d");
            return true;
        }
        return false;
    }

    @Override
    public UserListOfAppResBean queryPersonInfos(String appId, String appRegionalismCode, Integer pageNo, Integer pageSize) {
        UserListOfAppResBean userListOfAppResBean = new UserListOfAppResBean();
        ArrayList<PersonBean> personList = new ArrayList<PersonBean>();
        if (pageNo == null) {
            pageNo = 1;
        }
        if (pageSize == null) {
            pageSize = Integer.MAX_VALUE;
        }
        Page page = new Page();
        page.setPage(pageNo.intValue());
        page.setRp(pageSize.intValue());
        List<RoamTmpAppUseArea> list = this.roamAppAuthDao.queryAppPersonList(appId, appRegionalismCode, null, page);
        if (!CollectionUtils.isEmpty(list)) {
            PersonBean personBean = null;
            for (RoamTmpAppUseArea appUseArea : list) {
                personBean = new PersonBean();
                personBean.setPersonId(appUseArea.getPersonId());
                personBean.setPersonRegionalismCode(appUseArea.getRegionalismCode());
                personList.add(personBean);
            }
        }
        userListOfAppResBean.setPersonList(personList);
        userListOfAppResBean.setTotal(page.getTotal());
        return userListOfAppResBean;
    }
}

