/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.uas.roam.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xdja.uas.app.dao.AppDao;
import com.xdja.uas.bims.dao.PersonDao;
import com.xdja.uas.bims.entity.Department;
import com.xdja.uas.bims.entity.Person;
import com.xdja.uas.common.util.Base64Encrypt;
import com.xdja.uas.common.util.HttpRequestUtil;
import com.xdja.uas.common.util.Util;
import com.xdja.uas.roam.bean.Credential;
import com.xdja.uas.roam.bean.IdentifyAppInfo;
import com.xdja.uas.roam.bean.IdentifyPersonInfo;
import com.xdja.uas.roam.bean.InterfaceInfo;
import com.xdja.uas.roam.bean.PersonInfoBean;
import com.xdja.uas.roam.dao.AppCredentialDao;
import com.xdja.uas.roam.dao.PersonCredentialDao;
import com.xdja.uas.roam.entity.AppCredential;
import com.xdja.uas.roam.entity.PersonCredential;
import com.xdja.uas.roam.exception.RoamException;
import com.xdja.uas.roam.service.IdentifyService;
import com.xdja.uas.roam.service.SodService;
import com.xdja.uas.syms.entity.CommonCode;
import com.xdja.uas.syms.service.CommonCodeService;
import com.xdja.uas.syms.service.SystemConfigService;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IdentifyServiceImpl
implements IdentifyService {
    @Autowired
    private PersonCredentialDao personCredentialDao;
    @Autowired
    private AppCredentialDao appCredentialDao;
    @Autowired
    private AppDao appDao;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private PersonDao personDao;
    @Autowired
    private SodService sodService;
    @Autowired
    private CommonCodeService commonCodeService;
    private static final Logger logger = LoggerFactory.getLogger(IdentifyServiceImpl.class);

    @Override
    public IdentifyPersonInfo indentifyUserCredential(Credential userCredential, String backInfo) throws RoamException {
        PersonCredential personCredentialDetail;
        if (userCredential == null) {
            throw new RoamException("10006", "\u7528\u6237\u51ed\u8bc1\u4e3a\u7a7a");
        }
        long nowTime = System.currentTimeMillis();
        if (nowTime < Long.parseLong(userCredential.getHead().getDuration().getStartTime()) || nowTime > Long.parseLong(userCredential.getHead().getDuration().getEndTime())) {
            logger.error("\u7528\u6237\u51ed\u8bc1\u4fe1\u606f\u8fc7\u671f\u3002\u5f53\u524d\u65f6\u95f4:{}, \u51ed\u8bc1\u5230\u671f\u65f6\u95f4:{}", (Object)nowTime, (Object)JSON.toJSONString((Object)userCredential.getHead().getDuration()));
            throw new RoamException("10001", "\u7528\u6237\u51ed\u8bc1\u4fe1\u606f\u8fc7\u671f");
        }
        boolean isLocalCredential = this.isLocalRegion(userCredential.getHead().getToken().getOrgId());
        if (isLocalCredential && (personCredentialDetail = this.personCredentialDao.queryByTokenId(userCredential.getHead().getToken().getTokenId())) == null) {
            logger.error("\u7528\u6237\u8be5\u51ed\u8bc1\u4fe1\u606f\u4e0d\u5c5e\u4e8e\u79fb\u52a8\u8b66\u52a1\u5e73\u53f0\u53d1\u653e\u51ed\u8bc1\uff0c tokenId\uff1a{}", (Object)userCredential.getHead().getToken().getTokenId());
            throw new RoamException("10003", "\u7528\u6237\u8be5\u51ed\u8bc1\u4fe1\u606f\u4e0d\u5c5e\u4e8e\u79fb\u52a8\u8b66\u52a1\u5e73\u53f0\u53d1\u653e\u51ed\u8bc1");
        }
        String certificate = null;
        certificate = isLocalCredential ? this.getCertificate(userCredential.getHead().getToken().getOrgId()) : this.getRegionCertificate(userCredential.getHead().getToken().getOrgId());
        if (!"0".equals(backInfo)) {
            return null;
        }
        String localRegionalismCode = this.systemConfigService.getValueByCode("regionalismCode");
        PersonInfoBean personInfoBean = this.getPersonInfo(Util.getLocalAppCredential((String)localRegionalismCode), userCredential.getHead().getToken().getOrgId(), userCredential.getLoad().getUserInfo().getUserId());
        if (personInfoBean == null) {
            logger.error("\u83b7\u53d6\u5230\u7684\u4eba\u5458\u8be6\u60c5\u4e3a\u7a7a:{}", (Object)JSON.toJSONString((Object)userCredential.getLoad().getUserInfo()));
            return null;
        }
        IdentifyPersonInfo identifyPersonInfo = new IdentifyPersonInfo();
        BeanUtils.copyProperties((Object)personInfoBean, (Object)identifyPersonInfo);
        return identifyPersonInfo;
    }

    private PersonInfoBean getRemotePersonInfo(String appCredential, String personRegionCode, String personId) throws RoamException {
        InterfaceInfo interfaceInfo = null;
        try {
            interfaceInfo = this.sodService.queryRegionalInterface(personRegionCode, "IF-UA-SVC-03");
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u4ee3\u7801\u4e3aIF-UA-SVC-03\u7684\u63a5\u53e3\u8be6\u60c5\u5931\u8d25:{}", (Object)e.getMessage());
            throw new RoamException("10004", "\u83b7\u53d6\u4ee3\u7801\u4e3aIF-UA-SVC-03\u7684\u63a5\u53e3\u8be6\u60c5\u5931\u8d25");
        }
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        HashMap<String, String> headers = new HashMap<String, String>();
        String messageId = Util.getUUID();
        headers.put("messageId", messageId);
        headers.put("appCredential", appCredential);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("personId", personId);
        param.put("personRegionalismCode", personRegionCode);
        logger.debug("\u524d\u5f80\u5f02\u5730\u7edf\u4e00\u8ba4\u8bc1\u83b7\u53d6\u4eba\u5458\u4fe1\u606f\u53c2\u6570\uff1a{}", param);
        Map retMap = null;
        try {
            retMap = httpRequestUtil.httpPostJsonRet(interfaceInfo.getInterfaceUrl(), JSON.toJSONString(param), headers);
            logger.debug("\u8bf7\u6c42{}\u7684\u8fd4\u56de\u7ed3\u679c\u4e3a:{}:", (Object)interfaceInfo.getInterfaceUrl(), (Object)JSON.toJSONString((Object)retMap));
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5f02\u5730\u7528\u6237\u8be6\u60c5\u5931\u8d25:{}" + e.getMessage(), (Throwable)e);
            throw new RoamException("10004", "\u83b7\u53d6\u5f02\u5730\u7528\u6237\u8be6\u60c5\u5931\u8d25:" + e.getMessage());
        }
        if (!"0".equals(retMap.get("code"))) {
            logger.error("\u5f02\u5730\u83b7\u53d6\u7528\u6237\u8be6\u60c5\u5931\u8d25,code:{}, message:{}", retMap.get("code"), retMap.get("message"));
            throw new RoamException("10004", "[\u5f02\u5730]" + (String)retMap.get("message"));
        }
        PersonInfoBean personInfoBean = (PersonInfoBean)JSON.parseObject((String)((String)retMap.get("body")), PersonInfoBean.class);
        return personInfoBean;
    }

    @Override
    public IdentifyAppInfo indentifyAppCredential(Credential userCredential, Credential appCredential, String backInfo) throws RoamException {
        JSONObject appInfo;
        AppCredential appCredentialDetail;
        if (userCredential == null || appCredential == null) {
            throw new RoamException("10006", "\u7528\u6237\u6216\u5e94\u7528\u51ed\u8bc1\u4e3a\u7a7a");
        }
        long nowTime = System.currentTimeMillis();
        if (nowTime < Long.parseLong(appCredential.getHead().getDuration().getStartTime()) || nowTime > Long.parseLong(appCredential.getHead().getDuration().getEndTime())) {
            logger.error("\u5e94\u7528\u51ed\u8bc1\u4fe1\u606f\u8fc7\u671f\u3002\u5f53\u524d\u65f6\u95f4:{}, \u51ed\u8bc1\u5230\u671f\u65f6\u95f4:{}", (Object)nowTime, (Object)JSON.toJSONString((Object)appCredential.getHead().getDuration()));
            throw new RoamException("10001", "\u5e94\u7528\u51ed\u8bc1\u4fe1\u606f\u8fc7\u671f");
        }
        boolean isLocalCredential = this.isLocalRegion(appCredential.getHead().getToken().getOrgId());
        if (isLocalCredential && (appCredentialDetail = this.appCredentialDao.queryByTokenId(appCredential.getHead().getToken().getTokenId())) == null) {
            logger.error("\u5e94\u7528\u51ed\u8bc1\u4fe1\u606f\u4e0d\u5c5e\u4e8e\u79fb\u52a8\u8b66\u52a1\u5e73\u53f0\u53d1\u653e\u51ed\u8bc1\uff0c tokenId\uff1a{}", (Object)appCredential.getHead().getToken().getTokenId());
            throw new RoamException("10003", "\u5e94\u7528\u51ed\u8bc1\u4fe1\u606f\u4e0d\u5c5e\u4e8e\u79fb\u52a8\u8b66\u52a1\u5e73\u53f0\u53d1\u653e\u51ed\u8bc1");
        }
        this.indentifyUserCredential(userCredential, "1");
        String certificate = null;
        certificate = isLocalCredential ? this.getCertificate(appCredential.getHead().getToken().getOrgId()) : this.getRegionCertificate(appCredential.getHead().getToken().getOrgId());
        if (!"0".equals(backInfo) || "temporary auth app".equals(appCredential.getLoad().getAppInfo().getName())) {
            return null;
        }
        IdentifyAppInfo identifyAppInfo = new IdentifyAppInfo();
        String appOrgId = appCredential.getLoad().getAppInfo().getOrgId().substring(0, 2) + "0000000000";
        try {
            appInfo = this.sodService.queryAppInfo(appCredential.getLoad().getAppInfo().getAppId(), appOrgId, JSON.toJSONString((Object)userCredential));
        }
        catch (RoamException e) {
            logger.error("\u83b7\u53d6\u5f02\u5730\u5e94\u7528\u8be6\u60c5\u5931\u8d25:" + e.getMessage(), (Throwable)e);
            throw new RoamException("10004", "\u83b7\u53d6\u5f02\u5730\u5e94\u7528\u8be6\u60c5\u5931\u8d25");
        }
        if (appInfo == null) {
            logger.error("\u672a\u83b7\u53d6\u5230\u5f02\u5730\u5e94\u7528\u8be6\u60c5");
            throw new RoamException("10004", "\u672a\u83b7\u53d6\u5230\u5f02\u5730\u5e94\u7528\u8be6\u60c5");
        }
        identifyAppInfo.setAppId(appInfo.getString("appId"));
        identifyAppInfo.setAppRegionalismCode(appCredential.getLoad().getAppInfo().getOrgId());
        identifyAppInfo.setNetworkAreaCode(appInfo.getString("networkAreaCode"));
        identifyAppInfo.setAppName(appInfo.getString("appName"));
        identifyAppInfo.setAppPackage(appInfo.getString("appPackage"));
        identifyAppInfo.setAppType(appInfo.getString("appType"));
        identifyAppInfo.setAppDescription(appInfo.getString("appDescription"));
        identifyAppInfo.setAppFileSize(appInfo.getString("appFileSize"));
        return identifyAppInfo;
    }

    @Override
    public PersonInfoBean getPersonInfo(String appCredential, String personRegionalismCode, String personId) throws RoamException {
        PersonInfoBean personInfoBean = null;
        personInfoBean = this.isLocalRegion(personRegionalismCode) ? this.getLocalPersonInfo(personId) : this.getRemotePersonInfo(appCredential, personRegionalismCode, personId);
        return personInfoBean;
    }

    @Override
    public PersonInfoBean getLocalPersonInfo(String personId) {
        CommonCode gender;
        CommonCode position;
        CommonCode police;
        CommonCode personType;
        PersonInfoBean personInfoBean = null;
        Person person = this.personDao.queryPersonById(personId);
        if (person == null) {
            return personInfoBean;
        }
        personInfoBean = new PersonInfoBean();
        BeanUtils.copyProperties((Object)person, (Object)personInfoBean);
        personInfoBean.setPersonId(person.getId());
        personInfoBean.setPersonName(person.getName());
        personInfoBean.setPersonCode(person.getCode());
        personInfoBean.setPersonIdentifier(person.getIdentifier());
        Department department = person.getDepartment();
        if (department != null) {
            personInfoBean.setDepName(department.getName());
        }
        if ((personType = this.commonCodeService.getByCode(personInfoBean.getPersonType(), "PERSON_TYPE")) != null) {
            personInfoBean.setPersonType(personType.getName());
        }
        if ((police = this.commonCodeService.getByCode(personInfoBean.getPolice(), "2012")) != null) {
            personInfoBean.setPolice(police.getName());
        }
        if ((position = this.commonCodeService.getByCode(personInfoBean.getPosition(), "2011")) != null) {
            personInfoBean.setPosition(position.getName());
        }
        if ((gender = this.commonCodeService.getByCode(personInfoBean.getSex(), "sex")) != null) {
            personInfoBean.setSex(gender.getName());
        }
        return personInfoBean;
    }

    @Override
    public boolean isLocalRegion(String regionalismCode) {
        String localRegionalismCode = this.systemConfigService.getValueByCode("regionalismCode");
        return localRegionalismCode.equals(regionalismCode);
    }

    @Override
    public String getCertificate(String regionalismCode) throws RoamException {
        String certificate = "abcdefgh_abcdefgh_abcdefgh_abcdefgh_abcdefgh_abcdefgh_abcdefgh_abcdefgh_abcdefgh";
        Base64Encrypt base64Encrypt = new Base64Encrypt();
        return base64Encrypt.getBASE64("abcdefgh_abcdefgh_abcdefgh_abcdefgh_abcdefgh_abcdefgh_abcdefgh_abcdefgh_abcdefgh");
    }

    private String getRegionCertificate(String regionalismCode) throws RoamException {
        InterfaceInfo interfaceInfo = null;
        try {
            interfaceInfo = this.sodService.queryRegionalInterface(regionalismCode, "IF-UA-SVC-04");
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u4ee3\u7801\u4e3aIF-UA-SVC-04\u7684\u63a5\u53e3\u8be6\u60c5\u5931\u8d25:{}", (Object)e.getMessage());
            throw new RoamException("10004", "\u83b7\u53d6\u4ee3\u7801\u4e3aIF-UA-SVC-04\u7684\u63a5\u53e3\u8be6\u60c5\u5931\u8d25");
        }
        String localRegionalismCode = this.systemConfigService.getValueByCode("regionalismCode");
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        HashMap<String, String> headers = new HashMap<String, String>();
        String messageId = Util.getUUID();
        headers.put("messageId", messageId);
        String localAppCredential = Util.getLocalAppCredential((String)localRegionalismCode);
        headers.put("appCredential", localAppCredential);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("fromRegionalismCode", localRegionalismCode);
        logger.debug("\u524d\u5f80\u5f02\u5730\u83b7\u53d6\u6570\u5b57\u8bc1\u4e66\u53c2\u6570\uff1a{}", param);
        Map retMap = null;
        try {
            retMap = httpRequestUtil.httpPostJsonRet(interfaceInfo.getInterfaceUrl(), JSON.toJSONString(param), headers);
            logger.debug("\u8bf7\u6c42{}\u7684\u8fd4\u56de\u7ed3\u679c\u4e3a:{}:", (Object)interfaceInfo.getInterfaceUrl(), (Object)JSON.toJSONString((Object)retMap));
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5f02\u5730\u7528\u8bc1\u4e66\u5931\u8d25:{}" + e.getMessage(), (Throwable)e);
            throw new RoamException("10004", "\u83b7\u53d6\u5f02\u5730\u7528\u8bc1\u4e66\u5931\u8d25:" + e.getMessage());
        }
        if (!"0".equals(retMap.get("code"))) {
            logger.error("\u83b7\u53d6\u5f02\u5730\u7528\u8bc1\u4e66\u5931\u8d25,code:{}, message:{}", retMap.get("code"), retMap.get("message"));
            throw new RoamException("10004", "[\u5f02\u5730]" + (String)retMap.get("message"));
        }
        Map map = (Map)JSON.parseObject((String)((String)retMap.get("body")), Map.class);
        return (String)map.get("certificate");
    }
}

