/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.uas.roam.service.impl;

import com.alibaba.fastjson.JSON;
import com.xdja.uas.common.bean.RestfulQuery;
import com.xdja.uas.common.bean.RestfulResult;
import com.xdja.uas.common.bean.RoamPersonInfo;
import com.xdja.uas.common.util.HttpRequestUtil;
import com.xdja.uas.empower.entity.AppUseArea;
import com.xdja.uas.empower.service.EmpowerService;
import com.xdja.uas.roam.bean.RmcInterface;
import com.xdja.uas.roam.bean.RoamAppAuthInfo;
import com.xdja.uas.roam.dao.RoamAppAuthDao;
import com.xdja.uas.roam.dao.RoamPersonDao;
import com.xdja.uas.roam.entity.RoamAppUseArea;
import com.xdja.uas.roam.entity.RoamPerson;
import com.xdja.uas.roam.service.AppRoamService;
import com.xdja.uas.roam.service.RoamAppAuthService;
import com.xdja.uas.syms.service.SystemConfigService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.axis.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class RoamAppAuthServiceImpl
implements RoamAppAuthService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RoamAppAuthServiceImpl.class);
    @Autowired
    private RoamPersonDao personDao;
    @Autowired
    private RoamAppAuthDao appAuthDao;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private AppRoamService appRoamService;
    @Autowired
    private EmpowerService empowerService;

    @Override
    @Transactional
    public void appAuthChange(String version, RoamAppAuthInfo appAuthInfo) throws Exception {
        try {
            if (!"1.0".equals(version)) {
                throw new IllegalArgumentException("\u63a5\u53e3\u7248\u672c\u4fe1\u606f\u5f02\u5e38");
            }
            this.changetAuth_v1_0(appAuthInfo);
        }
        catch (Exception e) {
            LOGGER.error("\u53d8\u66f4\u5e94\u7528\u6743\u9650\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
            if (e instanceof IllegalArgumentException) {
                throw e;
            }
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public List<String> getAuthedPerson(String version, RoamAppAuthInfo appAuthInfo) throws Exception {
        try {
            if ("1.0".equals(version)) {
                return this.getAuthedPerson_v1_0(appAuthInfo);
            }
            throw new IllegalArgumentException("\u63a5\u53e3\u7248\u672c\u4fe1\u606f\u5f02\u5e38");
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5df2\u6536\u53d6\u4eba\u5458\u4fe1\u606f\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
            if (e instanceof IllegalArgumentException) {
                throw e;
            }
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public List<RoamAppUseArea> getPersonAppIds(String personId, String regionalismCode) throws Exception {
        List<RoamAppUseArea> list;
        try {
            String localRegionalismCode = this.systemConfigService.getValueByCode("regionalismCode");
            if (localRegionalismCode.equals(regionalismCode)) {
                List empowerList = this.empowerService.queryAppUseAreaByPersonId(personId);
                list = new ArrayList<RoamAppUseArea>();
                if (empowerList != null) {
                    for (AppUseArea appUseArea : empowerList) {
                        RoamAppUseArea roamAppUseArea = new RoamAppUseArea();
                        roamAppUseArea.setAppId(appUseArea.getAppId());
                        list.add(roamAppUseArea);
                    }
                }
            } else {
                list = this.appAuthDao.getPersonApp(personId, regionalismCode);
            }
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
        return list;
    }

    @Override
    public List<RoamAppUseArea> getPersonAllAppIds(String personId) {
        List<RoamAppUseArea> roamAppUseAreas;
        ArrayList<RoamAppUseArea> list = new ArrayList<RoamAppUseArea>();
        String localRegionalismCode = this.systemConfigService.getValueByCode("regionalismCode");
        List empowerList = this.empowerService.queryAppUseAreaByPersonId(personId);
        if (empowerList != null) {
            for (AppUseArea appUseArea : empowerList) {
                RoamAppUseArea roamAppUseArea = new RoamAppUseArea();
                roamAppUseArea.setAppId(appUseArea.getAppId());
                roamAppUseArea.setAppRegionalismCode(localRegionalismCode);
                list.add(roamAppUseArea);
            }
        }
        if (!CollectionUtils.isEmpty(roamAppUseAreas = this.appAuthDao.getPersonAllApps(personId))) {
            list.addAll(roamAppUseAreas);
        }
        return list;
    }

    private List<String> getAuthedPerson_v1_0(RoamAppAuthInfo appAuthInfo) {
        String personRegionalismCode = appAuthInfo.getPersonRegionalismCode();
        String appId = appAuthInfo.getAppId();
        String appRegionalismCode = appAuthInfo.getAppRegionalismCode();
        String appNetWorkCode = appAuthInfo.getAppNetworkCode();
        return this.appAuthDao.getAuthedPerson(appId, appRegionalismCode, appNetWorkCode, personRegionalismCode);
    }

    private void changetAuth_v1_0(RoamAppAuthInfo appAuthInfo) {
        this.checkParam(appAuthInfo);
        String localRegionalismCode = this.systemConfigService.getValueByCode("regionalismCode");
        String personRegionalismCode = appAuthInfo.getPersonRegionalismCode();
        String appId = appAuthInfo.getAppId();
        String appNetWorkCode = appAuthInfo.getAppNetworkCode();
        String appRegionalismCode = appAuthInfo.getAppRegionalismCode();
        try {
            this.appAuthDao.deleteRoamAppUserArea(appId, appRegionalismCode, appNetWorkCode, personRegionalismCode, "person");
            long currentTime = System.currentTimeMillis();
            List<RoamPersonInfo> rps = appAuthInfo.getPersonInfos();
            for (RoamPersonInfo rpi : rps) {
                RoamAppUseArea ra = new RoamAppUseArea();
                ra.setAppId(appId);
                ra.setAppNetworkCode(appNetWorkCode);
                ra.setAppRegionalismCode(appRegionalismCode);
                ra.setAreaId(rpi.getPersonId());
                ra.setType("person");
                ra.setAreaRegionalismCode(personRegionalismCode);
                this.appAuthDao.addRoamAppUserAreaEntity(ra);
                if (localRegionalismCode.equals(personRegionalismCode)) continue;
                RoamPerson rp = this.setRoamPerson(rpi, currentTime, personRegionalismCode);
                RoamPerson roamPerson = this.personDao.getByPersonIdAndRegionalismCode(rpi.getPersonId(), personRegionalismCode);
                if (roamPerson == null) {
                    rp.setnLastUpdateTime(currentTime++);
                    this.personDao.saveRoamPerson(rp);
                    continue;
                }
                this.resetRoamPersonInfo(rp, roamPerson);
                roamPerson.setnLastUpdateTime(currentTime++);
                this.personDao.saveRoamPerson(roamPerson);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u6743\u9650\u53d8\u66f4\u64cd\u4f5c\u6570\u636e\u5e93\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
            if (e instanceof IllegalArgumentException) {
                throw e;
            }
            throw new RuntimeException(e.getMessage());
        }
        if (!localRegionalismCode.equals(appRegionalismCode)) {
            try {
                this.roamAppAuth(appAuthInfo, "1.0");
            }
            catch (Exception e) {
                LOGGER.error("\u6743\u9650\u53d8\u66f4\u5f02\u5730\u8bf7\u6c42\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
                throw new RuntimeException(e.getMessage());
            }
        }
    }

    private void roamAppAuth(RoamAppAuthInfo appAuthInfo, String version) {
        try {
            RmcInterface uasInterface = this.appRoamService.getInterface(appAuthInfo.getAppRegionalismCode(), "3", "APPLY_CHANGE_POWER");
            Assert.notNull((Object)uasInterface, (String)"\u83b7\u53d6\u5f02\u5730uas\u5730\u5740\u5931\u8d25");
            HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
            RestfulQuery restfulQuery = new RestfulQuery();
            String messageId = UUID.randomUUID().toString().replace("-", "");
            restfulQuery.setMessageId(messageId);
            restfulQuery.setVersion(version);
            restfulQuery.setParameter((Object)appAuthInfo);
            String result = httpRequestUtil.httpPostJson(uasInterface.getInterfaceAddress(), JSON.toJSONString((Object)restfulQuery));
            RestfulResult restfulResult = RestfulResult.getInstance((String)result, Map.class);
            Assert.notNull((Object)restfulResult, (String)"\u53bb\u5e94\u7528\u5f52\u5c5e\u5730\u53d8\u66f4\u6743\u9650\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
            Assert.state((boolean)"200".equals(restfulResult.getCode()), (String)String.format("\u53bb\u5e94\u7528\u5f52\u5c5e\u5730\u53d8\u66f4\u6743\u9650\u7ed3\u679c\u5f02\u5e38: %s", restfulResult.getMessage()));
            Map map = (Map)restfulResult.getData();
            String code = (String)map.get("code");
            String message = (String)map.get("message");
            Assert.state((boolean)"1".equals(code), (String)String.format("\u5e94\u7528\u5f52\u5c5e\u5730\u53d8\u66f4\u6743\u9650\u5931\u8d25: %s", message));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private void checkParam(RoamAppAuthInfo appAuthInfo) {
        Assert.notNull((Object)appAuthInfo, (String)"\u53c2\u6570\u5f02\u5e38");
        Assert.hasText((String)appAuthInfo.getAppId(), (String)"\u5e94\u7528ID\u4e0d\u53ef\u7a7a");
        Assert.hasText((String)appAuthInfo.getAppNetworkCode(), (String)"\u5e94\u7528\u7f51\u7edc\u7c7b\u578b\u4e0d\u53ef\u7a7a");
        Assert.hasText((String)appAuthInfo.getAppRegionalismCode(), (String)"\u5e94\u7528\u5730\u533a\u7f16\u7801\u4e0d\u53ef\u7a7a");
        Assert.hasText((String)appAuthInfo.getPersonRegionalismCode(), (String)"\u4eba\u5458\u6240\u5c5e\u5730\u533a\u7f16\u7801\u4e0d\u53ef\u7a7a");
        Assert.notNull(appAuthInfo.getPersonInfos(), (String)"\u4eba\u5458\u4fe1\u606f\u4e0d\u53ef\u7a7a");
        for (RoamPersonInfo rpi : appAuthInfo.getPersonInfos()) {
            Assert.hasText((String)rpi.getPersonId(), (String)"\u4eba\u5458id\u4e0d\u53ef\u7a7a");
            Assert.hasText((String)rpi.getPersonIdentifier(), (String)"\u4eba\u5458\u8eab\u4efd\u8bc1\u4fe1\u606f\u4e0d\u53ef\u7a7a");
        }
    }

    private RoamPerson setRoamPerson(RoamPersonInfo rpi, long currentTime, String personRegionalismCode) {
        RoamPerson rp = new RoamPerson();
        rp.setPersonId(rpi.getPersonId());
        rp.setPersonType(rpi.getPersonType());
        rp.setCode(rpi.getPersonCode());
        rp.setCreateTime(currentTime);
        rp.setDepCode(rpi.getDepCode());
        rp.setDepId(rpi.getDepId());
        rp.setDepName(rpi.getDepName());
        rp.setIdentifier(rpi.getPersonIdentifier());
        rp.setMobile(rpi.getMobile());
        rp.setName(rpi.getPersonName());
        rp.setRegionalismCode(personRegionalismCode);
        rp.setSex(rpi.getSex());
        rp.setPolice(rpi.getPolice());
        rp.setPosition(rpi.getPosition());
        return rp;
    }

    private void resetRoamPersonInfo(RoamPerson source, RoamPerson target) {
        if (!StringUtils.isEmpty((String)source.getCode())) {
            target.setCode(source.getCode());
        }
        if (!StringUtils.isEmpty((String)source.getDepCode())) {
            target.setDepCode(source.getDepCode());
        }
        if (!StringUtils.isEmpty((String)source.getDepId())) {
            target.setDepId(source.getDepId());
        }
        if (!StringUtils.isEmpty((String)source.getDepName())) {
            target.setDepName(source.getDepName());
        }
        if (!StringUtils.isEmpty((String)source.getIdentifier())) {
            target.setIdentifier(source.getIdentifier());
        }
        if (!StringUtils.isEmpty((String)source.getMobile())) {
            target.setMobile(source.getMobile());
        }
        if (!StringUtils.isEmpty((String)source.getName())) {
            target.setName(source.getName());
        }
        if (!StringUtils.isEmpty((String)source.getPersonId())) {
            target.setPersonId(source.getPersonId());
        }
        if (!StringUtils.isEmpty((String)source.getPersonType())) {
            target.setPersonType(source.getPersonType());
        }
        if (!StringUtils.isEmpty((String)source.getRegionalismCode())) {
            target.setRegionalismCode(source.getRegionalismCode());
        }
        if (!StringUtils.isEmpty((String)source.getSex())) {
            target.setSex(source.getSex());
        }
        if (!StringUtils.isEmpty((String)source.getPolice())) {
            target.setPolice(source.getPolice());
        }
        if (!StringUtils.isEmpty((String)source.getPosition())) {
            target.setPosition(source.getPosition());
        }
    }
}

