/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.uas.roam.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.xdja.uas.app.entity.AppRoamInfo;
import com.xdja.uas.app.service.AppService;
import com.xdja.uas.bims.entity.Person;
import com.xdja.uas.bims.service.UserManageService;
import com.xdja.uas.common.bean.RestfulQuery;
import com.xdja.uas.common.bean.RestfulResult;
import com.xdja.uas.common.bean.RoamPersonInfo;
import com.xdja.uas.common.util.HttpRequestUtil;
import com.xdja.uas.common.util.HttpUtils;
import com.xdja.uas.common.util.Util;
import com.xdja.uas.empower.entity.AppUseArea;
import com.xdja.uas.empower.service.EmpowerService;
import com.xdja.uas.roam.bean.Credential;
import com.xdja.uas.roam.bean.Duration;
import com.xdja.uas.roam.bean.Head;
import com.xdja.uas.roam.bean.InterfaceInfo;
import com.xdja.uas.roam.bean.Load;
import com.xdja.uas.roam.bean.RmcInterface;
import com.xdja.uas.roam.bean.ServerSign;
import com.xdja.uas.roam.bean.Token;
import com.xdja.uas.roam.bean.UserInfo;
import com.xdja.uas.roam.bean.V1AppInfo;
import com.xdja.uas.roam.bean.V2AppInfo;
import com.xdja.uas.roam.dao.AppCredentialDao;
import com.xdja.uas.roam.dao.PersonCredentialDao;
import com.xdja.uas.roam.dao.RoamAppAuthDao;
import com.xdja.uas.roam.dao.RoamPersonDao;
import com.xdja.uas.roam.entity.AppCredential;
import com.xdja.uas.roam.entity.PersonCredential;
import com.xdja.uas.roam.entity.RoamAppUseArea;
import com.xdja.uas.roam.entity.RoamPerson;
import com.xdja.uas.roam.exception.RoamException;
import com.xdja.uas.roam.service.AppRoamService;
import com.xdja.uas.roam.service.AuthUserAppService;
import com.xdja.uas.roam.service.IdentifyService;
import com.xdja.uas.roam.service.RoamService;
import com.xdja.uas.roam.service.SodService;
import com.xdja.uas.scms.entity.Device;
import com.xdja.uas.scms.service.DeviceService;
import com.xdja.uas.sso.service.SingleSignOnService;
import com.xdja.uas.syms.service.SystemConfigService;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RoamServiceImpl
implements RoamService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RoamServiceImpl.class);
    @Autowired
    private UserManageService userManageService;
    @Autowired
    private DeviceService deviceService;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private SingleSignOnService singleSignOnService;
    @Autowired
    private AppService appService;
    @Autowired
    private AppCredentialDao appCredentialDao;
    @Autowired
    private PersonCredentialDao personCredentialDao;
    @Autowired
    private EmpowerService empowerService;
    @Autowired
    private RoamAppAuthDao roamAppAuthDao;
    @Autowired
    private AppRoamService appRoamService;
    @Autowired
    private RoamPersonDao roamPersonDao;
    @Autowired
    private AuthUserAppService authUserAppService;
    @Autowired
    private SodService sodService;
    @Autowired
    private IdentifyService identifyService;

    @Override
    @Transactional
    public Credential createUserCredential(String code, String imei, String imsi, String cardId, String version) throws RoamException {
        if ("1.0".equals(version)) {
            return this.createUserCredentialV1(code, imei, imsi, cardId);
        }
        throw new RoamException("7", "\u7248\u672c\u9519\u8bef");
    }

    @Override
    @Transactional
    public Credential createAppCredential(Credential userCredential, String appId, String appRegionalismCode, String appNetworkCode, String appPackage, String version) throws RoamException {
        if ("1.0".equals(version)) {
            return this.createAppCredentialV1(userCredential, appId, appRegionalismCode, appNetworkCode, appPackage);
        }
        if ("2.0".equals(version)) {
            return this.createAppCredentialV2(userCredential, appId, appRegionalismCode, appNetworkCode, appPackage);
        }
        throw new RoamException("7", "\u7248\u672c\u9519\u8bef");
    }

    private Credential createAppCredentialV2(Credential userCredential, String appId, String appRegionalismCode, String appNetworkCode, String appPackage) throws RoamException {
        long endTime;
        String appName;
        String localRegionalismCode = this.systemConfigService.getValueByCode("regionalismCode");
        this.identifyService.indentifyUserCredential(userCredential, "1");
        String appOrgId = appRegionalismCode.substring(0, 2) + "0000000000";
        this.authUserAppPower(userCredential, appId, appOrgId, appPackage, appNetworkCode);
        if (StringUtils.isBlank((CharSequence)localRegionalismCode)) {
            throw new RoamException("7", "\u521b\u5efa\u5e94\u7528\u51ed\u8bc1\u5931\u8d25\uff0c\u7cfb\u7edf\u672a\u914d\u7f6e\u672c\u5730\u884c\u653f\u533a\u57df\u7f16\u7801");
        }
        try {
            JSONObject jsonObject = this.sodService.queryAppInfo(appId, appOrgId, JSON.toJSONString((Object)userCredential));
            appName = jsonObject.getString("appName");
        }
        catch (RoamException e) {
            LOGGER.debug("\u672a\u83b7\u53d6\u5230\u5e94\u7528\u8be6\u60c5\u4fe1\u606f\uff0c\u91c7\u7528\u9ed8\u8ba4\u5e94\u7528\u4fe1\u606f");
            appName = "temporary auth app";
        }
        Credential credential = new Credential();
        Token token = new Token(null, localRegionalismCode, null);
        long startTime = System.currentTimeMillis();
        String appTokenExpiredTime = this.systemConfigService.getValueByCode("appTokenExpiredTime");
        if (StringUtils.isNotBlank((CharSequence)appTokenExpiredTime)) {
            endTime = startTime + Long.parseLong(appTokenExpiredTime) * 1000L;
        } else {
            LOGGER.warn("------>\u7cfb\u7edf\u672a\u914d\u7f6e\u5e94\u7528\u51ed\u8bc1\u8fc7\u671f\u65f6\u95f4\uff0c\u9ed8\u8ba4\u91c7\u7528120\u5206\u949f");
            endTime = startTime + 0x6DDD00L;
        }
        Duration duration = new Duration(String.valueOf(startTime), String.valueOf(endTime));
        Head head = new Head("1.0", Head.CRED_TYPE_APP, token, duration);
        head.setDuration(duration);
        credential.setHead(head);
        Load load = new Load();
        V2AppInfo appInfo = new V2AppInfo(appId, appRegionalismCode, appPackage, appName, "1", null, appNetworkCode);
        load.setAppInfo(appInfo);
        credential.setLoad(load);
        ServerSign serverSign = new ServerSign("SM3+SM2", "2WIjCJ/+94XmtIei2+/8eV40dxfvQGqV4ws7WDA5iNPc//zeZTFNewibqa8OSKprWq2P6mnWHMkVPYP+Qdl7Huc0qHJMVFUovF+mqtO5pSxrngem5kXmVK9v1NV7OMurPpa1FiQc1uU0A4Zae4ZrpynM2+qEck/D8KSvLvsKkCQ=", "b11000000000bdc", "http://192.168.24.108:8080");
        credential.setServerSign(serverSign);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("------>\u521b\u5efa\u5e94\u7528\u51ed\u8bc1\u6210\u529f\uff1a{},\u5f00\u59cb\u63d2\u5165\u6570\u636e\u5e93......", (Object)JSON.toJSONString((Object)credential));
        }
        AppCredential appCredential = new AppCredential(credential);
        String tokenId = this.appCredentialDao.insert(appCredential);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("------>\u5e94\u7528\u51ed\u8bc1\u63d2\u5165\u6570\u636e\u5e93\u6210\u529f\uff0ctokenId\uff1a{}", (Object)tokenId);
        }
        credential.getHead().getToken().setTokenId(tokenId);
        return credential;
    }

    private void authUserAppPower(Credential userCredential, String appId, String appOrgId, String appPackage, String appNetworkCode) throws RoamException {
        HttpUtils.ResponseWrap responseWrap;
        InterfaceInfo interfaceInfo;
        String localRegionalismCode = this.systemConfigService.getValueByCode("regionalismCode");
        UserInfo userInfo = userCredential.getLoad().getUserInfo();
        try {
            interfaceInfo = this.sodService.queryRegionalInterface(localRegionalismCode, "IF-UPM-SVC-01");
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u4ee3\u7801\u4e3aIF-UPM-SVC-01\u7684\u63a5\u53e3\u8be6\u60c5\u5931\u8d25:{}", (Object)e.getMessage());
            throw new RoamException("10004", "\u83b7\u53d6\u4ee3\u7801\u4e3aIF-UPM-SVC-01\u7684\u63a5\u53e3\u8be6\u60c5\u5931\u8d25");
        }
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("personId", userInfo.getUserId());
        parameter.put("personRegionalismCode", userCredential.getHead().getToken().getOrgId());
        parameter.put("appId", appId);
        parameter.put("appRegionalismCode", appOrgId);
        parameter.put("networkAreaCode", appNetworkCode);
        parameter.put("appPackage", appPackage);
        try {
            responseWrap = HttpUtils.createPost((String)interfaceInfo.getInterfaceUrl()).addJsonBody(parameter).addHeader("userCredential", URLEncoder.encode(JSON.toJSONString((Object)userCredential), "UTF-8")).execute();
        }
        catch (Exception e) {
            LOGGER.error("\u524d\u5f80\u7edf\u4e00\u6388\u6743\u8fdb\u884c\u7528\u6237\u5e94\u7528\u9274\u6743\u5931\u8d25:{}", (Object)e.getMessage());
            throw new RoamException("7", "\u524d\u5f80\u7edf\u4e00\u6388\u6743\u8fdb\u884c\u7528\u6237\u5e94\u7528\u9274\u6743\u5931\u8d25");
        }
        if (200 != responseWrap.statusCode()) {
            throw new RoamException("7", "\u524d\u5f80\u7edf\u4e00\u6388\u6743\u8fdb\u884c\u7528\u6237\u5e94\u7528\u9274\u6743\u5931\u8d25\uff0c\u72b6\u6001\u7801\u5f02\u5e38");
        }
        String code = responseWrap.getHeaderValue("code");
        String message = responseWrap.getHeaderValue("message");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u524d\u5f80\u7edf\u4e00\u6388\u6743\u8fdb\u884c\u7528\u6237\u5e94\u7528\u9274\u6743\u8fd4\u56de\u7ed3\u679c\uff1acode:{},message:{}", (Object)code, (Object)message);
        }
        if ("20001".equals(code)) {
            throw new RoamException("5", "\u8be5\u7528\u6237\u65e0\u4f7f\u7528\u8be5\u5e94\u7528\u6743\u9650");
        }
        if (!"0".equals(code)) {
            LOGGER.error("\u524d\u5f80\u7edf\u4e00\u6388\u6743\u8fdb\u884c\u7528\u6237\u5e94\u7528\u9274\u6743\u5931\u8d25\uff0c\u8fd4\u56decode\u5f02\u5e38\uff1a{}\uff0cmessage\uff1a{}", (Object)code, (Object)message);
            throw new RoamException("7", "\u524d\u5f80\u7edf\u4e00\u6388\u6743\u8fdb\u884c\u7528\u6237\u5e94\u7528\u9274\u6743\u5931\u8d25\uff0c\u8fd4\u56decode\u5f02\u5e38\uff1a" + code);
        }
    }

    @Override
    public RoamPersonInfo authUserCredential(Credential credential, String version) throws RoamException {
        if ("1.0".equals(version)) {
            return this.authUserCredentialV1(credential);
        }
        throw new RoamException("7", "\u7248\u672c\u9519\u8bef");
    }

    @Override
    public boolean authPersonAppPower(String userId, String personRegionalismCode, String appId, String appRegionalismCode, String appNetworkCode, String appPackage, String version) throws RoamException {
        if ("1.0".equals(version)) {
            return this.authPersonAppPowerV1(userId, personRegionalismCode, appId, appRegionalismCode, appNetworkCode, appPackage);
        }
        throw new RoamException("7", "\u7248\u672c\u9519\u8bef");
    }

    @Override
    public RoamPerson queryRoamPersonByIdAndRegionalismCode(String personId, String regionalismCode) {
        return this.roamPersonDao.getByPersonIdAndRegionalismCode(personId, regionalismCode);
    }

    @Override
    public void authAppCredential(Credential appCredential, String version) throws RoamException {
        if (!"1.0".equals(version)) {
            throw new RoamException("7", "\u7248\u672c\u9519\u8bef");
        }
        this.authAppCredentialV1(appCredential);
    }

    private void authAppCredentialV1(Credential credential) throws RoamException {
        LOGGER.debug("------>\u5f00\u59cb\u6821\u9a8c\u5e94\u7528\u51ed\u8bc1......");
        String localRegionalismCode = this.systemConfigService.getValueByCode("regionalismCode");
        if (StringUtils.isBlank((CharSequence)localRegionalismCode)) {
            throw new RoamException("7", "\u7cfb\u7edf\u672a\u914d\u7f6e\u672c\u5730\u884c\u653f\u533a\u57df\u7f16\u7801");
        }
        String regionalismCode = credential.getHead().getToken().getOrgId();
        if (localRegionalismCode.equals(regionalismCode)) {
            long endTime;
            LOGGER.debug("------>\u5e94\u7528\u51ed\u8bc1\u672c\u5730\u9a8c\u7b7e......");
            AppCredential appCredential = this.appCredentialDao.queryByTokenId(credential.getHead().getToken().getTokenId());
            if (appCredential == null) {
                throw new RoamException("6", "\u8be5\u51ed\u8bc1\u4fe1\u606f\u4e0d\u5c5e\u4e8e\u79fb\u52a8\u8b66\u52a1\u5e73\u53f0\u53d1\u653e\u51ed\u8bc1");
            }
            long now = System.currentTimeMillis();
            if (now > (endTime = appCredential.getEndTime().longValue())) {
                throw new RoamException("4", "\u51ed\u8bc1\u4fe1\u606f\u8fc7\u671f");
            }
        } else {
            LOGGER.debug("------>\u5e94\u7528\u51ed\u8bc1\u5f02\u5730\u9a8c\u7b7e......");
            String result = this.toOffsiteCheck(credential, "1.0");
            RestfulResult restfulResult = (RestfulResult)JSON.parseObject((String)result, (TypeReference)new TypeReference<RestfulResult<JSONObject>>(){}, (Feature[])new Feature[0]);
            JSONObject data = (JSONObject)restfulResult.getData();
            if (data == null) {
                throw new RoamException("7", "\u5f02\u5730\u9a8c\u7b7e\u5e94\u7528\u51ed\u8bc1\u5931\u8d25\uff0c\u8fd4\u56dedata\u4e3a\u7a7a");
            }
            if (!"0".equals(data.getString("code"))) {
                throw new RoamException(data.getString("code"), "[\u5f02\u5730]" + data.getString("message"));
            }
        }
    }

    private RoamPersonInfo authUserCredentialV1(Credential credential) throws RoamException {
        LOGGER.debug("------>\u5f00\u59cb\u6821\u9a8c\u7528\u6237\u51ed\u8bc1......");
        String localRegionalismCode = this.systemConfigService.getValueByCode("regionalismCode");
        if (StringUtils.isBlank((CharSequence)localRegionalismCode)) {
            throw new RoamException("7", "\u51ed\u8bc1\u5931\u8d25\uff0c\u7cfb\u7edf\u672a\u914d\u7f6e\u672c\u5730\u884c\u653f\u533a\u57df\u7f16\u7801");
        }
        String personId = credential.getLoad().getUserInfo().getUserId();
        String regionalismCode = credential.getHead().getToken().getOrgId();
        if (localRegionalismCode.equals(regionalismCode)) {
            long endTime;
            LOGGER.debug("------>\u7528\u6237\u51ed\u8bc1\u672c\u5730\u9a8c\u7b7e......");
            PersonCredential personCredential = this.personCredentialDao.queryByTokenId(credential.getHead().getToken().getTokenId());
            if (personCredential == null) {
                throw new RoamException("9", "\u7528\u6237\u8be5\u51ed\u8bc1\u4fe1\u606f\u4e0d\u5c5e\u4e8e\u79fb\u52a8\u8b66\u52a1\u5e73\u53f0\u53d1\u653e\u51ed\u8bc1");
            }
            long now = System.currentTimeMillis();
            if (now > (endTime = personCredential.getEndTime().longValue())) {
                throw new RoamException("1", "\u7528\u6237\u51ed\u8bc1\u4fe1\u606f\u8fc7\u671f");
            }
            Person person = this.userManageService.queryPersonById(personId);
            if (person == null) {
                throw new RoamException("7", "\u51ed\u8bc1\u4e2d\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
            }
            return RoamPersonInfo.personTransferToRoamBean((Person)person);
        }
        LOGGER.debug("------>\u7528\u6237\u51ed\u8bc1\u5f02\u5730\u9a8c\u7b7e......");
        String result = this.toOffsiteCheck(credential, "1.0");
        RestfulResult restfulResult = (RestfulResult)JSON.parseObject((String)result, (TypeReference)new TypeReference<RestfulResult<JSONObject>>(){}, (Feature[])new Feature[0]);
        JSONObject data = (JSONObject)restfulResult.getData();
        if (data == null) {
            throw new RoamException("7", "\u5f02\u5730\u9a8c\u7b7e\u5931\u8d25\uff0c\u8fd4\u56dedata\u4e3a\u7a7a");
        }
        if (!"0".equals(data.getString("code"))) {
            throw new RoamException(data.getString("code"), "[\u5f02\u5730]" + data.getString("message"));
        }
        return (RoamPersonInfo)data.getObject("personInfo", RoamPersonInfo.class);
    }

    private String toOffsiteCheck(Credential credential, String version) throws RoamException {
        LOGGER.debug("------>\u524d\u5f80\u5f02\u5730\u9a8c\u7b7e\u7968\u636e......");
        String regionalismCode = credential.getHead().getToken().getOrgId();
        RmcInterface offsiteUasAddress = this.appRoamService.getInterface(regionalismCode, "3", "CHECK_CREDENTIAL");
        if (offsiteUasAddress == null) {
            throw new RoamException("7", "\u5f02\u5730\u9a8c\u7b7e\u5931\u8d25\uff0c\u83b7\u53d6\u5f02\u5730UAS\u5730\u5740\u4e3a\u7a7a");
        }
        LOGGER.debug("------>\u524d\u5f80SOD\u83b7\u53d6\u5f02\u5730UAS\u5730\u5740\u4fe1\u606f\uff1a{}", (Object)Util.toJsonStr((Object)offsiteUasAddress));
        RestfulQuery restfulQuery = new RestfulQuery();
        restfulQuery.setMessageId(Util.getUUID());
        restfulQuery.setVersion(version);
        JSONObject parameter = new JSONObject();
        String credType = credential.getHead().getCredType();
        if (Head.CRED_TYPE_PERSON.equals(credType)) {
            parameter.put("userCredential", (Object)credential);
        } else if (Head.CRED_TYPE_APP.equals(credType)) {
            parameter.put("appCredential", (Object)credential);
        } else {
            throw new RoamException("7", "\u51ed\u8bc1\u7c7b\u578b\u9519\u8bef");
        }
        restfulQuery.setParameter((Object)parameter);
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        String param = JSON.toJSONString((Object)restfulQuery);
        LOGGER.debug("------>\u524d\u5f80\u5f02\u5730UAS\u6821\u9a8c\u7968\u636e\u53c2\u6570\uff1a{}", (Object)param);
        String result = httpRequestUtil.httpPostJson(offsiteUasAddress.getInterfaceAddress(), JSON.toJSONString((Object)restfulQuery));
        LOGGER.debug("<------\u524d\u5f80\u5f02\u5730UAS\u6821\u9a8c\u7968\u636e\u7ed3\u679c\uff1a{}", (Object)result);
        if (StringUtils.isBlank((CharSequence)result)) {
            throw new RoamException("7", "\u5f02\u5730\u9a8c\u7b7e\u5931\u8d25\uff0c\u83b7\u53d6\u5f02\u5730UAS\u5730\u5740\u4e3a\u7a7a");
        }
        return result;
    }

    private Credential createUserCredentialV1(String code, String imei, String imsi, String cardId) throws RoamException {
        long endTime;
        Person person = this.userManageService.getUserByCode(code);
        if (person == null) {
            throw new RoamException("1", "\u521b\u5efa\u5931\u8d25\uff0c\u8b66\u53f7\u4e0d\u5b58\u5728");
        }
        Device device = null;
        if (StringUtils.isNotBlank((CharSequence)cardId)) {
            device = this.deviceService.getByCardNO(cardId);
        }
        if (device == null) {
            LOGGER.warn("------>device \u4fe1\u606f\u4e3a\u7a7a");
        }
        boolean isCheckDevice = Boolean.parseBoolean(this.systemConfigService.getValueByCode("ifCheckDeivce"));
        LOGGER.info("------>\u68c0\u67e5\u5b89\u5168\u5361\u662f\u5426\u5b58\u5728\uff1a" + isCheckDevice);
        device = this.singleSignOnService.updateDevice(isCheckDevice, device, cardId, imsi, imei, person.getId(), null);
        if (device == null && isCheckDevice) {
            throw new RoamException("7", "\u521b\u5efa\u7528\u6237\u51ed\u8bc1\u5931\u8d25\uff0c\u5f00\u542f\u7528\u6237\u5361\u6821\u9a8c\u4f46\u662f\u672a\u627e\u5230\u5b89\u5168\u5361\u4fe1\u606f");
        }
        try {
            if (isCheckDevice && !this.singleSignOnService.checkBindingState(person.getId(), device, imei, imsi)) {
                throw new RoamException("7", "\u5b89\u5168\u5361\u7ed1\u5b9a\u4fe1\u606f\u9a8c\u8bc1\u672a\u901a\u8fc7");
            }
        }
        catch (Exception e) {
            LOGGER.error("------>\u6821\u9a8c\u4e09\u7801\u7ed1\u5b9a\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
            throw new RoamException("7", "\u6821\u9a8c\u4e09\u7801\u7ed1\u5b9a\u5f02\u5e38");
        }
        String localRegionalismCode = this.systemConfigService.getValueByCode("regionalismCode");
        if (StringUtils.isBlank((CharSequence)localRegionalismCode)) {
            throw new RoamException("7", "\u521b\u5efa\u7528\u6237\u51ed\u8bc1\u5931\u8d25\uff0c\u7cfb\u7edf\u672a\u914d\u7f6e\u672c\u5730\u884c\u653f\u533a\u57df\u7f16\u7801");
        }
        Credential credential = new Credential();
        Token token = new Token(null, localRegionalismCode, null);
        long startTime = System.currentTimeMillis();
        String userTokenExpiredTime = this.systemConfigService.getValueByCode("userTokenExpiredTime");
        if (StringUtils.isNotBlank((CharSequence)userTokenExpiredTime)) {
            endTime = startTime + Long.parseLong(userTokenExpiredTime) * 1000L;
        } else {
            LOGGER.warn("------>\u7cfb\u7edf\u672a\u914d\u7f6e\u7528\u6237\u51ed\u8bc1\u8fc7\u671f\u65f6\u95f4");
            endTime = startTime + 0x6DDD00L;
        }
        Duration duration = new Duration(String.valueOf(startTime), String.valueOf(endTime));
        Head head = new Head("1.0", Head.CRED_TYPE_PERSON, token, duration);
        credential.setHead(head);
        Load load = new Load();
        UserInfo userInfo = new UserInfo(person, localRegionalismCode);
        load.setUserInfo(userInfo);
        credential.setLoad(load);
        ServerSign serverSign = new ServerSign("SM3+SM2", "2WIjCJ/+94XmtIei2+/8eV40dxfvQGqV4ws7WDA5iNPc//zeZTFNewibqa8OSKprWq2P6mnWHMkVPYP+Qdl7Huc0qHJMVFUovF+mqtO5pSxrngem5kXmVK9v1NV7OMurPpa1FiQc1uU0A4Zae4ZrpynM2+qEck/D8KSvLvsKkCQ=", "b11000000000bdc", "http://192.168.24.108:8080");
        credential.setServerSign(serverSign);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("------>\u521b\u5efa\u7528\u6237\u51ed\u8bc1\u6210\u529f\uff1a{},\u5f00\u59cb\u63d2\u5165\u6570\u636e\u5e93......", (Object)JSON.toJSONString((Object)credential));
        }
        LOGGER.debug(Util.toJsonStr((Object)credential));
        PersonCredential personCredential = new PersonCredential(credential);
        String tokenId = this.personCredentialDao.insert(personCredential);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("------>\u7528\u6237\u51ed\u8bc1\u63d2\u5165\u6570\u636e\u5e93\u6210\u529f\uff0ctokenId\uff1a{}", (Object)tokenId);
        }
        credential.getHead().getToken().setTokenId(tokenId);
        return credential;
    }

    private Credential createAppCredentialV1(Credential userCredential, String appId, String appRegionalismCode, String appNetworkCode, String appPackage) throws RoamException {
        long endTime;
        String appPackageName;
        String appName;
        this.authUserCredentialV1(userCredential);
        UserInfo userInfo = userCredential.getLoad().getUserInfo();
        String appOrgId = appRegionalismCode.substring(0, 2) + "0000000000";
        boolean authAppPower = this.authPersonAppPowerV1(userInfo.getUserId(), userCredential.getHead().getToken().getOrgId(), appId, appOrgId, appNetworkCode, appPackage);
        if (!authAppPower) {
            throw new RoamException("5", "\u8be5\u7528\u6237\u65e0\u4f7f\u7528\u8be5\u5e94\u7528\u6743\u9650");
        }
        String localRegionalismCode = this.systemConfigService.getValueByCode("regionalismCode");
        if (StringUtils.isBlank((CharSequence)localRegionalismCode)) {
            throw new RoamException("7", "\u521b\u5efa\u5e94\u7528\u51ed\u8bc1\u5931\u8d25\uff0c\u7cfb\u7edf\u672a\u914d\u7f6e\u672c\u5730\u884c\u653f\u533a\u57df\u7f16\u7801");
        }
        if (!localRegionalismCode.equals(appRegionalismCode)) {
            try {
                RestfulResult result = this.queryOffsiteApp(appId, appRegionalismCode, appNetworkCode);
                JSONObject appInfo = (JSONObject)result.getData();
                appName = appInfo.getString("appName");
                appPackageName = appInfo.getString("appPackage");
            }
            catch (Exception e) {
                LOGGER.error("------>\u524d\u5f80\u5f02\u5730\u83b7\u53d6\u5e94\u7528\u4fe1\u606f\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
                throw new RoamException("7", "\u524d\u5f80\u5f02\u5730\u83b7\u53d6\u5e94\u7528\u4fe1\u606f\u5f02\u5e38");
            }
        } else {
            AppRoamInfo appInfo = this.appService.queryById(appId);
            if (appInfo == null) {
                throw new RoamException("4", "\u521b\u5efa\u5e94\u7528\u51ed\u8bc1\u5931\u8d25\uff0c\u672a\u67e5\u5230\u5e94\u7528\u4fe1\u606f");
            }
            appName = appInfo.getName();
            appPackageName = appInfo.getAppPackage();
        }
        Credential credential = new Credential();
        Token token = new Token(null, localRegionalismCode, null);
        long startTime = System.currentTimeMillis();
        String appTokenExpiredTime = this.systemConfigService.getValueByCode("appTokenExpiredTime");
        if (StringUtils.isNotBlank((CharSequence)appTokenExpiredTime)) {
            endTime = startTime + Long.parseLong(appTokenExpiredTime) * 1000L;
        } else {
            LOGGER.warn("------>\u7cfb\u7edf\u672a\u914d\u7f6e\u5e94\u7528\u51ed\u8bc1\u8fc7\u671f\u65f6\u95f4");
            endTime = startTime + 0x6DDD00L;
        }
        Duration duration = new Duration(String.valueOf(startTime), String.valueOf(endTime));
        Head head = new Head("1.0", Head.CRED_TYPE_APP, token, duration);
        credential.setHead(head);
        head.setDuration(duration);
        Load load = new Load();
        V1AppInfo appInfo = new V1AppInfo(appId, appRegionalismCode, appPackageName, appName, null, null, appNetworkCode);
        load.setAppInfo(appInfo);
        credential.setLoad(load);
        ServerSign serverSign = new ServerSign("SM3+SM2", "2WIjCJ/+94XmtIei2+/8eV40dxfvQGqV4ws7WDA5iNPc//zeZTFNewibqa8OSKprWq2P6mnWHMkVPYP+Qdl7Huc0qHJMVFUovF+mqtO5pSxrngem5kXmVK9v1NV7OMurPpa1FiQc1uU0A4Zae4ZrpynM2+qEck/D8KSvLvsKkCQ=", "b11000000000bdc", "http://192.168.24.108:8080");
        credential.setServerSign(serverSign);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("------>\u521b\u5efa\u5e94\u7528\u51ed\u8bc1\u6210\u529f\uff1a{},\u5f00\u59cb\u63d2\u5165\u6570\u636e\u5e93......", (Object)JSON.toJSONString((Object)credential));
        }
        AppCredential appCredential = new AppCredential(credential);
        String tokenId = this.appCredentialDao.insert(appCredential);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("------>\u5e94\u7528\u51ed\u8bc1\u63d2\u5165\u6570\u636e\u5e93\u6210\u529f\uff0ctokenId\uff1a{}", (Object)tokenId);
        }
        credential.getHead().getToken().setTokenId(tokenId);
        return credential;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean authPersonAppPowerV1(String userId, String personRegionalismCode, String appId, String appRegionalismCode, String appNetworkCode, String appPackage) throws RoamException {
        LOGGER.debug("------>\u5f00\u59cb\u6821\u9a8c\u7528\u6237\u5e94\u7528\u6743\u9650......");
        String localRegionalismCode = this.systemConfigService.getValueByCode("regionalismCode");
        if (StringUtils.isBlank((CharSequence)localRegionalismCode)) {
            throw new RoamException("7", "\u7cfb\u7edf\u672a\u914d\u7f6e\u672c\u5730\u884c\u653f\u533a\u57df\u7f16\u7801");
        }
        if (localRegionalismCode.equals(personRegionalismCode) && localRegionalismCode.equals(appRegionalismCode)) {
            LOGGER.debug("------>\u672c\u5730\u4eba\u5458\u672c\u5730\u5e94\u7528......");
            List list = this.empowerService.queryAppUseAreaByPersonId(userId);
            Set defaultLimits = this.empowerService.queryDefaultLimits();
            HashSet<String> limits = new HashSet<String>(defaultLimits);
            for (AppUseArea area : list) {
                limits.add(area.getAppId());
            }
            for (String string : limits) {
                if (!appId.equals(string)) continue;
                LOGGER.debug("------>\u6743\u9650\u6821\u9a8c\u901a\u8fc7\uff0c\u68c0\u67e5\u5305\u540d......");
                AppRoamInfo appInfo = this.appService.queryById(appId);
                if (appInfo == null) {
                    LOGGER.debug("------>\u5e93\u4e2d\u672a\u67e5\u5230\u8be5\u5e94\u7528\u4fe1\u606f\uff0c\u6821\u9a8c\u5931\u8d25......");
                    return false;
                }
                if (!"1".equals(appInfo.getAppFrameworkType())) continue;
                LOGGER.debug("------>\u5b89\u5353\u5e94\u7528\u68c0\u67e5\u4f20\u5165\u5305\u540d\u662f\u5426\u6b63\u786e......");
                if (appInfo.getAppPackage().equals(appPackage)) {
                    LOGGER.debug("------>\u5305\u540d\u6b63\u786e\uff0c\u9a8c\u8bc1\u6210\u529f......");
                    return true;
                }
                LOGGER.debug("------>\u5305\u540d\u4e0d\u7b26\uff0c\u9a8c\u8bc1\u5931\u8d25......\uff0c\u5e93\u4e2d\u5305\u540d\uff1a{}\uff0c\u4f20\u5165\u5305\u540d\uff1a{}", (Object)appInfo.getAppPackage(), (Object)appPackage);
                throw new RoamException("7", "\u5305\u540d\u4e0d\u7b26\uff0c\u9a8c\u8bc1\u5931\u8d25");
            }
            return false;
        } else {
            LOGGER.debug("------>\u5f00\u59cb\u6821\u9a8c\u5f02\u5730\u4eba\u5458\u5e94\u7528\u6743\u9650\u4fe1\u606f......");
            RoamAppUseArea roamAppUseArea = this.roamAppAuthDao.checkAuth(userId, personRegionalismCode, appId, appRegionalismCode, appNetworkCode);
            if (roamAppUseArea == null) return false;
            try {
                LOGGER.debug("------>\u6743\u9650\u6821\u9a8c\u901a\u8fc7\uff0c\u524d\u5f80mdp\u67e5\u8be2\u5f02\u5730\u5e94\u7528\u8be6\u60c5......");
                RestfulResult restfulResult = this.queryOffsiteApp(appId, appRegionalismCode, appNetworkCode);
                JSONObject appInfo = (JSONObject)restfulResult.getData();
                if (appInfo == null) return false;
                if (!"1".equals(appInfo.getString("appFrameworkType"))) return true;
                if (!StringUtils.isNotBlank((CharSequence)appPackage) || !appPackage.equals(appInfo.getString("appPackage"))) return false;
                return true;
            }
            catch (Exception e) {
                LOGGER.error("------>\u524d\u5f80\u5f02\u5730\u67e5\u8be2\u5e94\u7528\u8be6\u60c5\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
                return false;
            }
        }
    }

    private RestfulResult queryOffsiteApp(String appId, String appRegionalismCode, String appNetworkCode) throws Exception {
        String mdpUrl = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
        mdpUrl = mdpUrl + "/appManagerControl/queryOffsiteAppDetail.do";
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("appId", (Object)appId);
        jsonObject.put("regionalismCode", (Object)appRegionalismCode);
        RestfulQuery restfulQuery = new RestfulQuery(Util.getUUID(), "1.0", (Object)jsonObject);
        String query = JSON.toJSONString((Object)restfulQuery);
        LOGGER.debug("------>\u524d\u5f80mdp\u67e5\u8be2\u5f02\u5730\u5e94\u7528\u53c2\u6570\uff1a{}", (Object)query);
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        String result = URLDecoder.decode(httpRequestUtil.httpPostJson(mdpUrl, query), "utf-8");
        LOGGER.debug("<------\u524d\u5f80mdp\u67e5\u8be2\u5f02\u5730\u5e94\u7528\u7ed3\u679c\uff1a{}", (Object)result);
        if (StringUtils.isBlank((CharSequence)result)) {
            throw new Exception("\u524d\u5f80\u5f02\u5730\u83b7\u53d6\u5e94\u7528\u4fe1\u606f\u5f02\u5e38\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
        }
        return (RestfulResult)JSON.parseObject((String)result, (TypeReference)new TypeReference<RestfulResult<JSONObject>>(){}, (Feature[])new Feature[0]);
    }
}

