/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.uas.roam.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xdja.uas.common.bean.RestfulQuery;
import com.xdja.uas.common.bean.RestfulResult;
import com.xdja.uas.common.util.HttpRequestUtil;
import com.xdja.uas.common.util.HttpUtils;
import com.xdja.uas.common.util.Util;
import com.xdja.uas.roam.bean.InterfaceInfo;
import com.xdja.uas.roam.exception.RoamException;
import com.xdja.uas.roam.service.SodService;
import com.xdja.uas.roam.service.impl.AuthUserAppServiceImpl;
import com.xdja.uas.syms.service.SystemConfigService;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SodServiceImpl
implements SodService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthUserAppServiceImpl.class);
    @Autowired
    private SystemConfigService systemConfigService;

    @Override
    public JSONObject queryAppInfo(String appId, String appOrgId, String userCredential) throws RoamException {
        HttpUtils.ResponseWrap responseWrap;
        InterfaceInfo interfaceInfo;
        String localRegionalismCode = this.systemConfigService.getValueByCode("regionalismCode");
        try {
            interfaceInfo = this.queryRegionalInterface(localRegionalismCode, "IF-MAM-SVC-02");
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u4ee3\u7801\u4e3aIF-MAM-SVC-02\u7684\u63a5\u53e3\u8be6\u60c5\u5931\u8d25:{}", (Object)e.getMessage());
            throw new RoamException("10004", "\u83b7\u53d6\u4ee3\u7801\u4e3aIF-MAM-SVC-02\u7684\u63a5\u53e3\u8be6\u60c5\u5931\u8d25");
        }
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("appId", appId);
        parameter.put("appRegionalismCode", appOrgId);
        try {
            responseWrap = HttpUtils.createPost((String)interfaceInfo.getInterfaceUrl()).addJsonBody(parameter).addHeader("userCredential", URLEncoder.encode(userCredential, "UTF-8")).addHeader("appCredential", Util.getLocalAppCredential((String)localRegionalismCode)).execute();
        }
        catch (Exception e) {
            LOGGER.error("\u524d\u5f80\u5e94\u7528\u5e02\u573a\u83b7\u53d6\u5e94\u7528\u8be6\u60c5\u5931\u8d25:{}", (Object)e.getMessage());
            throw new RoamException("7", "\u524d\u5f80\u5e94\u7528\u5e02\u573a\u83b7\u53d6\u5e94\u7528\u8be6\u60c5\u5931\u8d25");
        }
        if (200 != responseWrap.statusCode()) {
            throw new RoamException("7", "\u524d\u5f80\u5e94\u7528\u5e02\u573a\u83b7\u53d6\u5e94\u7528\u8be6\u60c5\u5931\u8d25\uff0c\u72b6\u6001\u7801\u5f02\u5e38");
        }
        String code = responseWrap.getHeaderValue("code");
        String message = responseWrap.getHeaderValue("message");
        String result = responseWrap.getString();
        if (StringUtils.isBlank((CharSequence)result)) {
            throw new RoamException("4", "\u524d\u5f80\u5e94\u7528\u5e02\u573a\u83b7\u53d6\u5e94\u7528\u8be6\u60c5\u5931\u8d25\uff0c\u8fd4\u56de\u5185\u5bb9\u4e3a\u7a7a");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u524d\u5f80\u5e94\u7528\u5e02\u573a\u83b7\u53d6\u5e94\u7528\u8be6\u60c5\u8fd4\u56de\u7ed3\u679c\uff1acode:{},message:{},result:{}", new Object[]{code, message, result});
        }
        return JSONObject.parseObject((String)result);
    }

    @Override
    public RestfulResult<List<InterfaceInfo>> queryRegionalInterfaceList(String regionalismCode, List<String> interfaceCodes) throws Exception {
        String sodUrl = this.systemConfigService.getValueByCode("sodUrl");
        sodUrl = sodUrl + "/interfaces/queryRegionalInterfaces";
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("regionalismCode", (Object)regionalismCode);
        jsonObject.put("interfaceCodes", interfaceCodes);
        RestfulQuery restfulQuery = new RestfulQuery(Util.getUUID(), "1.0", (Object)jsonObject);
        String query = JSON.toJSONString((Object)restfulQuery);
        LOGGER.debug("------>\u67e5\u8be2\u5f02\u5730\u63a5\u53e3\u5217\u8868\u53c2\u6570\uff1a{}", (Object)query);
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        String result = URLDecoder.decode(httpRequestUtil.httpPostJson(sodUrl, query), "utf-8");
        LOGGER.debug("<-----\u67e5\u8be2\u5f02\u5730\u63a5\u53e3\u5217\u8868\u7ed3\u679c\uff1a{}", (Object)result);
        if (StringUtils.isBlank((CharSequence)result)) {
            throw new RoamException("7", "\u524d\u5f80\u5f02\u5730\u83b7\u53d6\u63a5\u53e3\u5217\u8868\u5f02\u5e38\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
        }
        return RestfulResult.getInstanceListDate((String)result, InterfaceInfo.class);
    }

    @Override
    public InterfaceInfo queryRegionalInterface(String regionalismCode, String interfaceCode) throws Exception {
        ArrayList<String> interfaceCodeList = new ArrayList<String>();
        interfaceCodeList.add(interfaceCode);
        RestfulResult<List<InterfaceInfo>> restfulResult = this.queryRegionalInterfaceList(regionalismCode, interfaceCodeList);
        if (restfulResult == null || restfulResult.getData() == null || ((List)restfulResult.getData()).size() == 0) {
            LOGGER.error("\u67e5\u8be2\u5f02\u5730\u63a5\u53e3\u5217\u8868\u5f02\u5e38\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
            throw new RoamException("7", "\u524d\u5f80\u5f02\u5730\u83b7\u53d6\u63a5\u53e3\u5217\u8868\u5f02\u5e38\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
        }
        return (InterfaceInfo)((List)restfulResult.getData()).get(0);
    }
}

