/*
 * Decompiled with CFR 0.152.
 */
package com.zry.logdie.asm;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\n\u000bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/zry/logdie/asm/LogKillerHelper;", "", "()V", "debug", "", "killLog", "", "inputByte", "setLogDebug", "", "MyClassVisitor", "MyMethodVisitor", "myplugin"})
public final class LogKillerHelper {
    private static boolean debug;
    public static final LogKillerHelper INSTANCE;

    public final void setLogDebug(boolean debug) {
        LogKillerHelper.debug = debug;
    }

    @NotNull
    public final byte[] killLog(@NotNull byte[] inputByte) {
        Intrinsics.checkParameterIsNotNull((Object)inputByte, (String)"inputByte");
        ClassReader cr = new ClassReader(inputByte);
        ClassWriter cw = new ClassWriter(cr, 0);
        MyClassVisitor myClassVisitor = new MyClassVisitor((ClassVisitor)cw);
        cr.accept((ClassVisitor)myClassVisitor, 8);
        byte[] byArray = cw.toByteArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"cw.toByteArray()");
        return byArray;
    }

    private LogKillerHelper() {
    }

    static {
        LogKillerHelper logKillerHelper;
        INSTANCE = logKillerHelper = new LogKillerHelper();
    }

    public static final /* synthetic */ boolean access$getDebug$p(LogKillerHelper $this) {
        LogKillerHelper logKillerHelper = $this;
        return debug;
    }

    public static final /* synthetic */ void access$setDebug$p(LogKillerHelper $this, boolean bl) {
        LogKillerHelper logKillerHelper = $this;
        debug = bl;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003JK\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0010\u0010\u0012\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0005\u0018\u00010\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u000bH\u0016JE\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00052\b\u0010\u0018\u001a\u0004\u0018\u00010\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0010\u0010\u0019\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0005\u0018\u00010\u0013H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u001a\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u00052\b\u0010\u001d\u001a\u0004\u0018\u00010\u0005H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u001e"}, d2={"Lcom/zry/logdie/asm/LogKillerHelper$MyClassVisitor;", "Lorg/objectweb/asm/ClassVisitor;", "classVisitor", "(Lorg/objectweb/asm/ClassVisitor;)V", "className", "", "getClassName", "()Ljava/lang/String;", "setClassName", "(Ljava/lang/String;)V", "visit", "", "version", "", "access", "name", "signature", "superName", "interfaces", "", "(IILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "visitEnd", "visitMethod", "Lorg/objectweb/asm/MethodVisitor;", "descriptor", "exceptions", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Lorg/objectweb/asm/MethodVisitor;", "visitSource", "source", "debug", "myplugin"})
    public static final class MyClassVisitor
    extends ClassVisitor {
        @NotNull
        private String className;

        @NotNull
        public final String getClassName() {
            return this.className;
        }

        public final void setClassName(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
            this.className = string;
        }

        public void visit(int version, int access, @NotNull String name, @Nullable String signature, @Nullable String superName, @Nullable String[] interfaces) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            super.visit(version, access, name, signature, superName, interfaces);
            this.className = name;
            if (LogKillerHelper.access$getDebug$p(INSTANCE)) {
                String string = "----------start " + this.className + " visitor-------------";
                System.out.println((Object)string);
            }
        }

        public void visitSource(@NotNull String source, @Nullable String debug) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            super.visitSource(source, debug);
        }

        @NotNull
        public MethodVisitor visitMethod(int access, @Nullable String name, @Nullable String descriptor, @Nullable String signature, @Nullable String[] exceptions) {
            MethodVisitor mv;
            MethodVisitor methodVisitor = mv = super.visitMethod(access, name, descriptor, signature, exceptions);
            Intrinsics.checkExpressionValueIsNotNull((Object)methodVisitor, (String)"mv");
            return new MyMethodVisitor(methodVisitor, this.className);
        }

        public void visitEnd() {
            super.visitEnd();
            if (LogKillerHelper.access$getDebug$p(INSTANCE)) {
                String string = "----------end " + this.className + " visitor-------------";
                System.out.println((Object)string);
            }
        }

        public MyClassVisitor(@NotNull ClassVisitor classVisitor) {
            Intrinsics.checkParameterIsNotNull((Object)classVisitor, (String)"classVisitor");
            super(262144, classVisitor);
            this.className = "";
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0002J0\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0014H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u00020\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lcom/zry/logdie/asm/LogKillerHelper$MyMethodVisitor;", "Lorg/objectweb/asm/MethodVisitor;", "oldMv", "className", "", "(Lorg/objectweb/asm/MethodVisitor;Ljava/lang/String;)V", "getClassName", "()Ljava/lang/String;", "matchMethod", "", "", "getOldMv", "()Lorg/objectweb/asm/MethodVisitor;", "setOldMv", "(Lorg/objectweb/asm/MethodVisitor;)V", "autoPut", "", "key", "value", "isMatch", "", "name", "desc", "visitMethodInsn", "opcode", "", "owner", "descriptor", "isInterface", "myplugin"})
    public static final class MyMethodVisitor
    extends MethodVisitor {
        private final Map<String, List<String>> matchMethod;
        @NotNull
        private MethodVisitor oldMv;
        @NotNull
        private final String className;

        public final void autoPut(@NotNull String key, @NotNull String value) {
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            List listTmp = this.matchMethod.get(key);
            if (listTmp == null) {
                listTmp = new ArrayList();
                Map<String, List<String>> map = this.matchMethod;
                List list = listTmp;
                map.put(key, list);
            }
            listTmp.add((String)value);
        }

        private final boolean isMatch(String name, String desc) {
            List<String> list = this.matchMethod.get(name);
            return list != null ? list.contains(desc) : false;
        }

        public void visitMethodInsn(int opcode, @NotNull String owner, @NotNull String name, @NotNull String descriptor, boolean isInterface) {
            Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
            if (opcode == 184 && this.isMatch(name, descriptor)) {
                String string = "check " + this.className + " method name " + name + ", desc " + descriptor + " is match, will replace";
                System.out.println((Object)string);
                this.oldMv.visitMethodInsn(opcode, "com/zry/logdie/util/DieLog", name, descriptor, isInterface);
                return;
            }
            super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
        }

        @NotNull
        public final MethodVisitor getOldMv() {
            return this.oldMv;
        }

        public final void setOldMv(@NotNull MethodVisitor methodVisitor) {
            Intrinsics.checkParameterIsNotNull((Object)methodVisitor, (String)"<set-?>");
            this.oldMv = methodVisitor;
        }

        @NotNull
        public final String getClassName() {
            return this.className;
        }

        public MyMethodVisitor(@NotNull MethodVisitor oldMv, @NotNull String className) {
            Map map;
            Intrinsics.checkParameterIsNotNull((Object)oldMv, (String)"oldMv");
            Intrinsics.checkParameterIsNotNull((Object)className, (String)"className");
            super(262144, oldMv);
            this.oldMv = oldMv;
            this.className = className;
            MyMethodVisitor myMethodVisitor = this;
            myMethodVisitor.matchMethod = map = (Map)new LinkedHashMap();
            this.autoPut("v", "(Ljava/lang/String;Ljava/lang/String;)I");
            this.autoPut("v", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Throwable;)I");
            this.autoPut("d", "(Ljava/lang/String;Ljava/lang/String;)I");
            this.autoPut("d", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Throwable;)I");
            this.autoPut("i", "(Ljava/lang/String;Ljava/lang/String;)I");
            this.autoPut("i", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Throwable;)I");
            this.autoPut("w", "(Ljava/lang/String;Ljava/lang/String;)I");
            this.autoPut("w", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Throwable;)I");
            this.autoPut("w", "(Ljava/lang/String;Ljava/lang/Throwable;)I");
            this.autoPut("e", "(Ljava/lang/String;Ljava/lang/String;)I");
            this.autoPut("e", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Throwable;)I");
        }
    }
}

