/*
 * Decompiled with CFR 0.152.
 */
package io.jpress.core;

import com.jfinal.aop.Before;
import com.jfinal.core.ActionException;
import com.jfinal.core.Controller;
import com.jfinal.core.JFinal;
import com.jfinal.ext.interceptor.NotAction;
import com.jfinal.i18n.Res;
import com.jfinal.render.JsonRender;
import com.jfinal.render.Render;
import com.jfinal.upload.UploadFile;
import io.jpress.core.JSession;
import io.jpress.core.render.AjaxResult;
import io.jpress.core.render.JCaptchaRender;
import io.jpress.model.User;
import io.jpress.utils.AttachmentUtils;
import io.jpress.utils.JsoupUtils;
import io.jpress.utils.RequestUtils;
import io.jpress.utils.StringUtils;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class JBaseController
extends Controller {
    private static final char URL_PARA_SEPARATOR = JFinal.me().getConstants().getUrlParaSeparator().toCharArray()[0];
    private JSession session = new JSession(this);
    private int mParaCount = -1;

    public String getPara(String name) {
        return JsoupUtils.clear((String)this.getRequest().getParameter(name));
    }

    public String getPara(String name, String defaultValue) {
        String html = this.getRequest().getParameter(name);
        if (null != html) {
            return JsoupUtils.clear((String)html);
        }
        return defaultValue;
    }

    public int getParaCount() {
        char[] parachars;
        if (this.mParaCount != -1) {
            return this.mParaCount;
        }
        this.mParaCount = 0;
        char[] cArray = parachars = this.getPara() == null ? null : this.getPara().toCharArray();
        if (parachars != null) {
            this.mParaCount = 1;
            for (char c : parachars) {
                if (URL_PARA_SEPARATOR != c) continue;
                ++this.mParaCount;
            }
        }
        return this.mParaCount;
    }

    public boolean isMoblieBrowser() {
        return RequestUtils.isMoblieBrowser((HttpServletRequest)this.getRequest());
    }

    public boolean isWechatBrowser() {
        return RequestUtils.isWechatBrowser((HttpServletRequest)this.getRequest());
    }

    public boolean isIEBrowser() {
        return RequestUtils.isIEBrowser((HttpServletRequest)this.getRequest());
    }

    public boolean isAjaxRequest() {
        return RequestUtils.isAjaxRequest((HttpServletRequest)this.getRequest());
    }

    public boolean isMultipartRequest() {
        return RequestUtils.isMultipartRequest((HttpServletRequest)this.getRequest());
    }

    protected int getPageNumber() {
        int page = this.getParaToInt("page", 1);
        if (page < 1) {
            page = 1;
        }
        return page;
    }

    protected int getPageSize() {
        int size = this.getParaToInt("size", 10);
        if (size < 1) {
            size = 1;
        }
        return size;
    }

    public void setHeader(String key, String value) {
        this.getResponse().setHeader(key, value);
    }

    public Res getI18nRes() {
        return (Res)this.getAttr("i18n");
    }

    public String getI18nValue(String key) {
        return this.getI18nRes().get(key);
    }

    @Before(value={NotAction.class})
    public void renderAjaxResultForSuccess() {
        this.renderAjaxResult("success", 0, null);
    }

    public void renderAjaxResultForSuccess(String message) {
        this.renderAjaxResult(message, 0, null);
    }

    public void renderAjaxResultForSuccess(String message, Object data) {
        this.renderAjaxResult(message, 0, data);
    }

    @Before(value={NotAction.class})
    public void renderAjaxResultForError() {
        this.renderAjaxResult("error", 1, null);
    }

    public void renderAjaxResultForError(String message) {
        this.renderAjaxResult(message, 1, null);
    }

    public void renderAjaxResult(String message, int errorCode) {
        this.renderAjaxResult(message, errorCode, null);
    }

    public void renderAjaxResult(String message, int errorCode, Object data) {
        AjaxResult ar = new AjaxResult();
        ar.setMessage(message);
        ar.setErrorCode(errorCode);
        ar.setData(data);
        if (this.isIEBrowser()) {
            this.render((Render)new JsonRender((Object)ar).forIE());
        } else {
            this.renderJson(ar);
        }
    }

    @Before(value={NotAction.class})
    public void createToken() {
        this.createToken("jtoken");
    }

    public boolean validateToken() {
        return this.validateToken("jtoken");
    }

    public HttpSession getSession() {
        return this.session;
    }

    public HttpSession getSession(boolean create) {
        return this.getSession();
    }

    public <T> T getSessionAttr(String key) {
        return (T)this.session.getAttribute(key);
    }

    public Controller setSessionAttr(String key, Object value) {
        this.session.setAttribute(key, value);
        return this;
    }

    public Controller removeSessionAttr(String key) {
        this.session.removeAttribute(key);
        return this;
    }

    @Before(value={NotAction.class})
    public void renderCaptcha() {
        this.render(new JCaptchaRender(this));
    }

    public boolean validateCaptcha(String paraName) {
        return JCaptchaRender.validate(this, this.getPara(paraName));
    }

    public BigInteger[] getParaValuesToBigInteger(String name) {
        String[] values = this.getRequest().getParameterValues(name);
        if (values == null) {
            return null;
        }
        BigInteger[] result = new BigInteger[values.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new BigInteger(values[i]);
        }
        return result;
    }

    public BigInteger getParaToBigInteger() {
        return this.toBigInteger(this.getPara(), null);
    }

    public BigInteger getParaToBigInteger(int index) {
        return this.toBigInteger(this.getPara(index), null);
    }

    public BigInteger getParaToBigInteger(int index, BigInteger defaultValue) {
        return this.toBigInteger(this.getPara(index), defaultValue);
    }

    public BigInteger getParaToBigInteger(String name) {
        return this.toBigInteger(this.getRequest().getParameter(name), null);
    }

    public BigInteger getParaToBigInteger(String name, BigInteger defaultValue) {
        return this.toBigInteger(this.getRequest().getParameter(name), defaultValue);
    }

    private BigInteger toBigInteger(String value, BigInteger defaultValue) {
        try {
            if (value == null || "".equals(value.trim())) {
                return defaultValue;
            }
            if ((value = value.trim()).startsWith("N") || value.startsWith("n")) {
                return new BigInteger(value).negate();
            }
            return new BigInteger(value);
        }
        catch (Exception e) {
            throw new ActionException(404, "Can not parse the parameter \"" + value + "\" to BigInteger value.");
        }
    }

    @Before(value={NotAction.class})
    public String getIPAddress() {
        return RequestUtils.getIpAddress((HttpServletRequest)this.getRequest());
    }

    public User getLoginedUser() {
        return (User)this.getAttr("USER");
    }

    @Before(value={NotAction.class})
    public String getUserAgent() {
        return RequestUtils.getUserAgent((HttpServletRequest)this.getRequest());
    }

    public Map<String, String> getMetas(Map<String, String> filesMap) {
        String key;
        HashMap<String, String> metas = null;
        Map requestMap = this.getParaMap();
        if (requestMap != null && !requestMap.isEmpty()) {
            for (Map.Entry<String, String> entry : requestMap.entrySet()) {
                key = entry.getKey();
                if (!key.startsWith("meta:")) continue;
                if (metas == null) {
                    metas = new HashMap();
                }
                String value = null;
                for (String v : (String[])entry.getValue()) {
                    if (!StringUtils.isNotEmpty((String)v)) continue;
                    value = v;
                    break;
                }
                metas.put(key.substring(5), value);
            }
        }
        if (filesMap != null) {
            for (Map.Entry<String, String> entry : filesMap.entrySet()) {
                key = entry.getKey();
                if (!key.startsWith("meta:")) continue;
                if (metas == null) {
                    metas = new HashMap<String, String>();
                }
                metas.put(key.substring(5), entry.getValue());
            }
        }
        return metas;
    }

    public Map<String, String> getMetas() {
        return this.getMetas(this.getUploadFilesMap());
    }

    public HashMap<String, String> getUploadFilesMap() {
        List fileList = null;
        if (this.isMultipartRequest()) {
            fileList = this.getFiles();
        }
        HashMap<String, String> filesMap = null;
        if (fileList != null) {
            filesMap = new HashMap<String, String>();
            for (UploadFile ufile : fileList) {
                String filePath = AttachmentUtils.moveFile((UploadFile)ufile).replace("\\", "/");
                filesMap.put(ufile.getParameterName(), filePath);
            }
        }
        return filesMap;
    }
}

