/*
 * Decompiled with CFR 0.152.
 */
package io.jpress.core.addon;

import com.jfinal.kit.PathKit;
import com.jfinal.log.Log;
import io.jpress.core.addon.Addon;
import io.jpress.core.addon.AddonClassLoader;
import io.jpress.core.addon.AddonInfo;
import io.jpress.model.query.OptionQuery;
import io.jpress.utils.FileUtils;
import io.jpress.utils.StringUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class AddonManager {
    public static final String MESSAGE_ON_ADDON_LOAD_START = "addonManager:on_addon_load_start";
    public static final String MESSAGE_ON_ADDON_LOAD_FINISHED = "addonManager:on_addon_load_finished";
    public static final String MESSAGE_ON_ADDON_STARTUP_START = "addonManager:on_addon_startup_start";
    public static final String MESSAGE_ON_ADDON_STARTUP_FINISHED = "addonManager:on_addon_startup_finished";
    private static final Log log = Log.getLog(AddonManager.class);
    private final Map<String, AddonInfo> addonMap = new ConcurrentHashMap<String, AddonInfo>();
    private static AddonManager manager = new AddonManager();

    private AddonManager() {
        this.autoInstall();
        this.autoStart();
    }

    public static AddonManager me() {
        return manager;
    }

    public AddonInfo findById(String id) {
        if (id == null) {
            return null;
        }
        return this.addonMap.get(id);
    }

    public boolean start(AddonInfo addon) {
        OptionQuery.me().saveOrUpdate(this.buildOptionKey(addon), Boolean.TRUE.toString());
        return addon.start();
    }

    public boolean stop(AddonInfo addon) {
        OptionQuery.me().saveOrUpdate(this.buildOptionKey(addon), Boolean.FALSE.toString());
        return addon.stop();
    }

    private String buildOptionKey(AddonInfo addon) {
        return "addon_start_" + addon.getId();
    }

    public boolean install(File file) {
        AddonInfo addon = this.loadAddonByJarFile(file);
        if (addon == null) {
            return false;
        }
        return this.registerAddon(addon);
    }

    public boolean uninstall(AddonInfo addon) {
        this.stop(addon);
        File addonJarFile = new File(PathKit.getWebRootPath(), addon.getJarPath());
        if (addonJarFile.exists()) {
            this.unRegisterAddon(addon);
            return addonJarFile.delete();
        }
        return false;
    }

    public List<AddonInfo> getAddons() {
        ArrayList<AddonInfo> lis = new ArrayList<AddonInfo>();
        for (Map.Entry<String, AddonInfo> entry : this.addonMap.entrySet()) {
            lis.add(entry.getValue());
        }
        return lis;
    }

    public List<AddonInfo> getStartedAddons() {
        ArrayList<AddonInfo> list = new ArrayList<AddonInfo>();
        for (Map.Entry<String, AddonInfo> entry : this.addonMap.entrySet()) {
            if (!entry.getValue().isStart()) continue;
            list.add(entry.getValue());
        }
        return list;
    }

    public boolean registerAddon(AddonInfo addon) {
        if (this.addonMap.containsKey(addon.getId())) {
            return false;
        }
        this.addonMap.put(addon.getId(), addon);
        return true;
    }

    public void unRegisterAddon(AddonInfo addon) {
        this.addonMap.remove(addon.getId());
    }

    private void autoInstall() {
        File[] files;
        File addonsFile = new File(PathKit.getWebRootPath(), "/WEB-INF/addons");
        if (addonsFile.exists() && (files = addonsFile.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".jar");
            }
        })) != null && files.length > 0) {
            for (File file : files) {
                this.install(file);
            }
        }
    }

    private void autoStart() {
        for (Map.Entry<String, AddonInfo> entry : this.addonMap.entrySet()) {
            Boolean start = OptionQuery.me().findValueAsBool(this.buildOptionKey(entry.getValue()));
            if (start == null || !start.booleanValue()) continue;
            this.start(entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AddonInfo loadAddonByJarFile(File file) {
        AddonInfo addon;
        block29: {
            AddonInfo addonInfo;
            addon = null;
            JarFile jarFile = null;
            URLClassLoader acl = null;
            try {
                jarFile = new JarFile(file);
                acl = new AddonClassLoader(file.getAbsolutePath());
                ((AddonClassLoader)acl).init();
                ((AddonClassLoader)acl).autoLoadClass(jarFile);
                Manifest mf = jarFile.getManifest();
                Attributes attr = mf.getMainAttributes();
                if (attr == null) break block29;
                String id = attr.getValue("Addon-Id");
                if (StringUtils.isBlank((String)id)) {
                    log.warn("addon " + file.getParentFile() + " must has id");
                    AddonInfo addonInfo2 = null;
                    return addonInfo2;
                }
                String className = attr.getValue("Addon-Class");
                String title = attr.getValue("Addon-Title");
                String description = attr.getValue("Addon-Description");
                String author = attr.getValue("Addon-Author");
                String authorWebsite = attr.getValue("Addon-Author-Website");
                String version = attr.getValue("Addon-Version");
                String versionCode = attr.getValue("Addon-Version-Code");
                addon = new AddonInfo();
                addon.setId(id);
                addon.setTitle(title);
                addon.setAddonClass(className);
                addon.setDescription(description);
                addon.setAuthor(author);
                addon.setAuthorWebsite(authorWebsite);
                addon.setVersion(version);
                addon.setVersionCode(Integer.parseInt(versionCode.trim()));
                addon.setJarPath(FileUtils.removeRootPath((String)file.getAbsolutePath()));
                Class<?> clazz = acl.loadClass(className);
                addon.setAddon((Addon)clazz.newInstance());
                addonInfo = addon;
            }
            catch (Throwable e) {
                addon.setHasError(true);
                log.error("AddonManager loadAddon error", e);
                break block29;
            }
            finally {
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (IOException e) {}
                }
                if (acl != null) {
                    try {
                        acl.close();
                    }
                    catch (IOException e) {}
                }
            }
            return addonInfo;
        }
        return addon;
    }

    public Object invokeHook(String hookName, Object ... objects) {
        List<AddonInfo> addons = this.getStartedAddons();
        for (AddonInfo addonInfo : addons) {
            if (addonInfo.getHasError()) continue;
            Addon addon = addonInfo.getAddon();
            Object obj = addon.getHooks().invokeHook(hookName, objects);
            if (addon.letNextHookInvoke()) continue;
            return obj;
        }
        return null;
    }
}

