/*
 * Decompiled with CFR 0.152.
 */
package io.jpress.core.cache;

import com.jfinal.core.Action;
import com.jfinal.core.JFinal;
import com.jfinal.handler.Handler;
import com.jfinal.log.Log;
import io.jpress.core.cache.ActionCache;
import io.jpress.core.cache.ActionCacheManager;
import io.jpress.utils.StringUtils;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ActionCacheHandler
extends Handler {
    static String[] urlPara = new String[]{null};
    static Log log = Log.getLog(ActionCacheHandler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(String target, HttpServletRequest request, HttpServletResponse response, boolean[] isHandled) {
        if (ActionCacheManager.isCloseActionCache()) {
            this.next.handle(target, request, response, isHandled);
            return;
        }
        Action action = JFinal.me().getAction(target, urlPara);
        if (action == null) {
            this.next.handle(target, request, response, isHandled);
            return;
        }
        ActionCache actionCache = action.getMethod().getAnnotation(ActionCache.class);
        if (actionCache == null && (actionCache = action.getControllerClass().getAnnotation(ActionCache.class)) == null) {
            this.next.handle(target, request, response, isHandled);
            return;
        }
        String originalTarget = (String)request.getAttribute("_original_target");
        String cacheKey = StringUtils.isNotBlank((String)originalTarget) ? originalTarget : target;
        String queryString = request.getQueryString();
        if (queryString != null) {
            queryString = "?" + queryString;
            cacheKey = cacheKey + queryString;
        }
        ActionCacheManager.enableCache(request);
        ActionCacheManager.setCacheKey(request, cacheKey);
        ActionCacheManager.setCacheContentType(request, actionCache.contentType());
        String renderContent = ActionCacheManager.getCache(request, cacheKey);
        if (renderContent != null) {
            response.setContentType(actionCache.contentType());
            try (PrintWriter writer = null;){
                writer = response.getWriter();
                writer.write(renderContent);
                isHandled[0] = true;
            }
        } else {
            this.next.handle(target, request, response, isHandled);
        }
    }
}

