/*
 * Decompiled with CFR 0.152.
 */
package io.jpress.core.render;

import com.jfinal.kit.HashKit;
import com.jfinal.kit.LogKit;
import com.jfinal.kit.StrKit;
import com.jfinal.render.Render;
import com.jfinal.render.RenderException;
import io.jpress.core.JBaseController;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.QuadCurve2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;

public class JCaptchaRender
extends Render {
    private static String captchaName = "_jpress_captcha";
    private static final int WIDTH = 108;
    private static final int HEIGHT = 40;
    private static final String[] strArr = new String[]{"3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F", "G", "H", "J", "K", "M", "N", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y"};
    private static final Font[] RANDOM_FONT = new Font[]{new Font("nyala", 1, 38), new Font("Arial", 1, 32), new Font("Bell MT", 1, 32), new Font("Credit valley", 1, 34), new Font("Impact", 1, 32), new Font("Monospaced", 1, 40)};
    private final JBaseController controller;

    public JCaptchaRender(JBaseController controller) {
        this.controller = controller;
    }

    public void render() {
        BufferedImage image = new BufferedImage(108, 40, 1);
        String vCode = this.drawGraphic(image);
        vCode = vCode.toUpperCase();
        vCode = HashKit.md5((String)vCode);
        this.controller.setSessionAttr(captchaName, vCode);
        this.response.setHeader("Pragma", "no-cache");
        this.response.setHeader("Cache-Control", "no-cache");
        this.response.setDateHeader("Expires", 0L);
        this.response.setContentType("image/jpeg");
        ServletOutputStream sos = null;
        try {
            sos = this.response.getOutputStream();
            ImageIO.write((RenderedImage)image, "jpeg", (OutputStream)sos);
        }
        catch (IOException e) {
            if (JCaptchaRender.getDevMode()) {
                throw new RenderException((Throwable)e);
            }
        }
        catch (Exception e) {
            throw new RenderException((Throwable)e);
        }
        finally {
            if (sos != null) {
                try {
                    sos.close();
                }
                catch (IOException e) {
                    LogKit.logNothing((Throwable)e);
                }
            }
        }
    }

    private String drawGraphic(BufferedImage image) {
        Color color;
        Graphics2D g = image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setColor(this.getRandColor(200, 250));
        g.fillRect(0, 0, 108, 40);
        Random random = new Random();
        g.setFont(RANDOM_FONT[random.nextInt(RANDOM_FONT.length)]);
        for (int i = 0; i < 10; ++i) {
            color = this.getRandColor(120, 200);
            g.setColor(color);
            g.drawOval(random.nextInt(108), random.nextInt(40), 5 + random.nextInt(10), 5 + random.nextInt(10));
            color = null;
        }
        String sRand = "";
        for (int i = 0; i < 4; ++i) {
            String rand = String.valueOf(strArr[random.nextInt(strArr.length)]);
            sRand = sRand + rand;
            int degree = random.nextInt(28);
            if (i % 2 == 0) {
                degree *= -1;
            }
            int x = 22 * i;
            int y = 21;
            g.rotate(Math.toRadians(degree), x, y);
            color = this.getRandColor(20, 130);
            g.setColor(color);
            g.drawString(rand, x + 8, y + 10);
            g.rotate(-Math.toRadians(degree), x, y);
            color = null;
        }
        g.setColor(this.getRandColor(0, 60));
        BasicStroke bs = new BasicStroke(3.0f);
        g.setStroke(bs);
        QuadCurve2D.Double curve = new QuadCurve2D.Double(0.0, random.nextInt(32) + 4, 54.0, 20.0, 108.0, random.nextInt(32) + 4);
        g.draw(curve);
        g.dispose();
        return sRand;
    }

    private Color getRandColor(int fc, int bc) {
        Random random = new Random();
        if (fc > 255) {
            fc = 255;
        }
        if (bc > 255) {
            bc = 255;
        }
        int r = fc + random.nextInt(bc - fc);
        int g = fc + random.nextInt(bc - fc);
        int b = fc + random.nextInt(bc - fc);
        return new Color(r, g, b);
    }

    public static boolean validate(JBaseController controller, String userInputCaptcha) {
        if (StrKit.isBlank((String)userInputCaptcha)) {
            return false;
        }
        userInputCaptcha = userInputCaptcha.toUpperCase();
        boolean result = (userInputCaptcha = HashKit.md5((String)userInputCaptcha)).equals(controller.getSessionAttr(captchaName));
        if (result) {
            controller.removeSessionAttr(captchaName);
        }
        return result;
    }
}

