/*
 * Decompiled with CFR 0.152.
 */
package io.jpress.menu;

import io.jpress.menu.MenuItem;
import io.jpress.utils.StringUtils;
import java.util.LinkedList;
import java.util.List;

public class MenuGroup {
    public static final String TYPE_NORMAL = "_normal";
    public static final String TYPE_BLOCK = "_block";
    private String id;
    private String iconClass;
    private String text;
    private String type = "_normal";
    private List<MenuItem> menuItems;

    public MenuGroup() {
    }

    public MenuGroup(String id, String iconClass, String text) {
        this.id = id;
        this.iconClass = iconClass;
        this.text = text;
    }

    public MenuGroup(String id, String iconClass, String text, String type) {
        this.id = id;
        this.iconClass = iconClass;
        this.text = text;
        this.type = type;
    }

    public static MenuGroup createBlockGroup() {
        MenuGroup group = new MenuGroup();
        group.setType(TYPE_BLOCK);
        return group;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getIconClass() {
        return this.iconClass;
    }

    public void setIconClass(String iconClass) {
        this.iconClass = iconClass;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List<MenuItem> getMenuItems() {
        return this.menuItems;
    }

    public void setMenuItems(List<MenuItem> menuItems) {
        this.menuItems = menuItems;
    }

    public void addMenuItem(MenuItem item) {
        if (this.menuItems == null) {
            this.menuItems = new LinkedList<MenuItem>();
        }
        this.menuItems.add(item);
    }

    public void addMenuItem(int index, MenuItem item) {
        if (this.menuItems == null) {
            this.menuItems = new LinkedList<MenuItem>();
        }
        this.menuItems.add(index, item);
    }

    public void removeMenuItemById(String id) {
        if (StringUtils.isBlank((String)id)) {
            return;
        }
        if (this.menuItems == null || this.menuItems.isEmpty()) {
            return;
        }
        MenuItem deleteItem = null;
        for (MenuItem item : this.menuItems) {
            if (!id.equals(item.getId())) continue;
            deleteItem = item;
            break;
        }
        if (deleteItem != null) {
            this.menuItems.remove(deleteItem);
        }
    }

    public String generateHtml() {
        if (TYPE_BLOCK.equals(this.type)) {
            return "<li class=\"jpress_block\"></li>";
        }
        StringBuilder htmlBuilder = new StringBuilder();
        htmlBuilder.append("<li class=\"treeview\" id=\"" + this.id + "\">");
        htmlBuilder.append("<a href=\"#\">");
        htmlBuilder.append("<i class=\"" + this.iconClass + "\" ></i>");
        htmlBuilder.append("<span>" + this.text + "</span>");
        htmlBuilder.append("<i class=\"fa fa-angle-left pull-right\" ></i>");
        htmlBuilder.append("</a>");
        htmlBuilder.append("<ul class=\"treeview-menu\">");
        if (this.menuItems != null && this.menuItems.size() > 0) {
            for (MenuItem item : this.menuItems) {
                htmlBuilder.append(item.generateHtml());
            }
        }
        htmlBuilder.append("</ul>");
        htmlBuilder.append("</li>");
        return htmlBuilder.toString();
    }
}

