/*
 * Decompiled with CFR 0.152.
 */
package io.jpress.notify.sms;

import com.jfinal.log.Log;
import io.jpress.core.Jpress;
import io.jpress.model.query.OptionQuery;
import io.jpress.notify.sms.ISmsSender;
import io.jpress.notify.sms.SmsMessage;
import io.jpress.utils.EncryptUtils;
import io.jpress.utils.HttpUtils;
import io.jpress.utils.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

public class AlidayuSmsSender
implements ISmsSender {
    private static final Log log = Log.getLog(AlidayuSmsSender.class);

    @Override
    public boolean send(SmsMessage sms) {
        String app_key = OptionQuery.me().findValue("sms_app_key");
        String app_secret = OptionQuery.me().findValue("sms_app_secret");
        String sendResult = AlidayuSmsSender.doSend(sms, app_key, app_secret);
        if (Jpress.isDevMode()) {
            System.err.println("sms send result:" + sendResult);
        }
        return StringUtils.isNotBlank((String)sendResult) && sendResult != null && sendResult.contains("alibaba_aliqin_fc_sms_num_send_response") && sendResult.contains("success") && sendResult.contains("true");
    }

    private static String doSend(SmsMessage sms, String app_key, String app_secret) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("format", "json");
        params.put("method", "alibaba.aliqin.fc.sms.num.send");
        params.put("sign_method", "md5");
        String timestamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
        params.put("timestamp", timestamp);
        params.put("v", "2.0");
        params.put("rec_num", sms.getRec_num());
        params.put("sms_free_sign_name", sms.getSign_name());
        params.put("sms_param", sms.getParam());
        params.put("sms_template_code", sms.getTemplate());
        params.put("sms_type", "normal");
        params.put("app_key", app_key);
        String sign = EncryptUtils.signForRequest(params, (String)app_secret);
        params.put("sign", sign);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");
        try {
            return HttpUtils.post((String)"http://gw.api.taobao.com/router/rest", params, headers);
        }
        catch (Exception e) {
            log.error("AlidayuSmsSender doSend http exception", (Throwable)e);
            return null;
        }
    }

    public static void main(String[] args) {
        SmsMessage sms = new SmsMessage();
        sms.setContent("test");
        sms.setRec_num("18600000000");
        sms.setTemplate("SMS_6730856");
        sms.setParam("{\"code\":\"8888\",\"product\":\"JPress\",\"customer\":\"\u6768\u798f\u6d77\"}");
        sms.setSign_name("\u767b\u5f55\u9a8c\u8bc1");
        boolean sendOk = new AlidayuSmsSender().send(sms);
        System.out.println(sendOk);
        System.out.println("===============finished!===================");
    }
}

