/*
 * Decompiled with CFR 0.152.
 */
package io.jpress.router;

import com.jfinal.core.Action;
import com.jfinal.core.JFinal;
import com.jfinal.log.Log;
import io.jpress.core.Jpress;
import io.jpress.core.addon.HookInvoker;
import io.jpress.model.query.OptionQuery;
import io.jpress.model.router.ContentRouter;
import io.jpress.model.router.PageRouter;
import io.jpress.model.router.RouterConverter;
import io.jpress.model.router.TaxonomyRouter;
import io.jpress.router.RouterNotAllowConvert;
import io.jpress.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RouterManager {
    private static final Log log = Log.getLog(RouterManager.class);
    static String[] urlPara = new String[]{null};
    static List<RouterConverter> converters = new ArrayList<RouterConverter>();

    public static String converte(String target, HttpServletRequest request, HttpServletResponse response) {
        String hookTarget;
        if (!Jpress.isInstalled()) {
            return target;
        }
        if ("/".equals(target)) {
            return target;
        }
        Action action = JFinal.me().getAction(target, urlPara);
        if (action != null) {
            RouterNotAllowConvert notAllowConvert = action.getControllerClass().getAnnotation(RouterNotAllowConvert.class);
            if (notAllowConvert != null) {
                return target;
            }
            notAllowConvert = action.getMethod().getAnnotation(RouterNotAllowConvert.class);
            if (notAllowConvert != null) {
                return target;
            }
        }
        if (StringUtils.isNotBlank((String)(hookTarget = HookInvoker.routerConverte(target, request, response)))) {
            return hookTarget;
        }
        if (target.indexOf(46) != -1) {
            int index;
            Boolean fakeStaticEnable = OptionQuery.me().findValueAsBool("router_fakestatic_enable");
            if (fakeStaticEnable == null || !fakeStaticEnable.booleanValue()) {
                return target;
            }
            String fakeStaticSuffix = OptionQuery.me().findValue("router_fakestatic_suffix");
            if (!StringUtils.isNotBlank((String)fakeStaticSuffix)) {
                fakeStaticSuffix = ".html";
            }
            if (-1 == (index = target.lastIndexOf(fakeStaticSuffix))) {
                return target;
            }
            target = target.substring(0, index);
        }
        try {
            for (RouterConverter c : converters) {
                String newTarget = c.converter(target, request, response);
                if (newTarget == null) continue;
                if (Jpress.isDevMode()) {
                    String formatString = "target\"%s\" was converted to \"%s\" by %s.(%s.java:1)";
                    System.err.println(String.format(formatString, target, newTarget, c.getClass().getName(), c.getClass().getSimpleName()));
                }
                return newTarget;
            }
        }
        catch (Exception e) {
            log.warn("IRouterConverter converter exception", (Throwable)e);
        }
        return target;
    }

    static {
        converters.add((RouterConverter)new TaxonomyRouter());
        converters.add((RouterConverter)new PageRouter());
        converters.add((RouterConverter)new ContentRouter());
    }
}

