/*
 * Decompiled with CFR 0.152.
 */
package io.jpress.ui.freemarker.tag;

import io.jpress.core.render.freemarker.JTag;
import io.jpress.model.Content;
import io.jpress.model.query.ContentQuery;
import io.jpress.model.vo.Archive;
import io.jpress.utils.StringUtils;
import java.util.List;

public class ArchivesTag
extends JTag {
    public static final String TAG_NAME = "jp.archives";

    @Override
    public void onRender() {
        String module = this.getParam("module", "article");
        if (StringUtils.isBlank((String)module)) {
            this.renderText("");
            return;
        }
        List list = ContentQuery.me().findArchives(module);
        if (list == null || list.isEmpty()) {
            this.renderText("");
            return;
        }
        List contents = ContentQuery.me().findArchiveByModule(module);
        if (contents == null || contents.isEmpty()) {
            this.renderText("");
            return;
        }
        for (Content c : contents) {
            String archiveDate = c.getStr("archiveDate");
            if (archiveDate == null) continue;
            for (Archive a : list) {
                if (!archiveDate.equals(a.getDate())) continue;
                a.addData((Object)c);
            }
        }
        this.setVariable("archives", list);
        this.renderBody();
    }
}

