/*
 * Decompiled with CFR 0.152.
 */
package io.jpress.ui.freemarker.tag;

import com.jfinal.core.JFinal;
import com.jfinal.plugin.activerecord.Page;
import io.jpress.core.render.freemarker.BasePaginateTag;
import io.jpress.core.render.freemarker.JTag;
import io.jpress.model.Comment;
import io.jpress.model.Content;
import io.jpress.model.query.CommentQuery;
import io.jpress.utils.StringUtils;
import javax.servlet.http.HttpServletRequest;

public class CommentPageTag
extends JTag {
    public static final String TAG_NAME = "jp.commentPage";
    Content content;
    int pageNumber;
    HttpServletRequest request;

    public CommentPageTag(HttpServletRequest request, Content content, int pageNumber) {
        this.request = request;
        this.content = content;
        this.pageNumber = pageNumber;
    }

    @Override
    public void onRender() {
        int pageSize = this.getParamToInt("pageSize", 10);
        Page page = CommentQuery.me().paginateByContentId(this.pageNumber, pageSize, this.content.getId());
        this.setVariable("page", page);
        this.setVariable("comments", page.getList());
        CommentPaginateTag pagination = new CommentPaginateTag(this.request, (Page<Comment>)page, this.content);
        this.setVariable("pagination", pagination);
        this.renderBody();
    }

    public static class CommentPaginateTag
    extends BasePaginateTag {
        final Content content;
        final HttpServletRequest request;

        public CommentPaginateTag(HttpServletRequest request, Page<Comment> page, Content content) {
            super(page);
            this.request = request;
            this.content = content;
        }

        @Override
        protected String getUrl(int pageNumber) {
            String url = this.content.getUrlWithPageNumber(pageNumber);
            String queryString = this.request.getQueryString();
            if (StringUtils.isNotBlank((String)queryString)) {
                url = url + "?" + queryString;
            }
            if (StringUtils.isNotBlank((String)this.getAnchor())) {
                url = url + "#" + this.getAnchor();
            }
            return JFinal.me().getContextPath() + url;
        }
    }
}

