/*
 * Decompiled with CFR 0.152.
 */
package io.jpress.ui.freemarker.tag;

import com.jfinal.core.JFinal;
import com.jfinal.plugin.activerecord.Page;
import io.jpress.core.render.freemarker.BasePaginateTag;
import io.jpress.core.render.freemarker.JTag;
import io.jpress.model.Content;
import io.jpress.model.ModelSorter;
import io.jpress.model.Taxonomy;
import io.jpress.model.query.ContentQuery;
import io.jpress.model.query.TaxonomyQuery;
import io.jpress.utils.StringUtils;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class ContentPageTag
extends JTag {
    public static final String TAG_NAME = "jp.contentPage";
    int pageNumber;
    String moduleName;
    String orderBy;
    List<Taxonomy> taxonomys;
    HttpServletRequest request;

    public ContentPageTag(HttpServletRequest request, int pageNumber, String moduleName, List<Taxonomy> taxonomys, String orderBy) {
        this.request = request;
        this.pageNumber = pageNumber;
        this.moduleName = moduleName;
        this.taxonomys = taxonomys;
        this.orderBy = orderBy;
    }

    @Override
    public void onRender() {
        boolean containChild;
        int pagesize = this.getParamToInt("pageSize", 10);
        this.orderBy = StringUtils.isBlank((String)this.orderBy) ? this.getParam("orderBy") : this.orderBy;
        BigInteger[] taxonomyIds = null;
        if (this.taxonomys != null && this.taxonomys.size() > 0) {
            taxonomyIds = new BigInteger[this.taxonomys.size()];
            for (int i = 0; i < taxonomyIds.length; ++i) {
                taxonomyIds[i] = this.taxonomys.get(i).getId();
            }
        }
        if (taxonomyIds != null && taxonomyIds.length > 0 && (containChild = this.getParamToBool("containChild", false).booleanValue())) {
            for (Taxonomy taxonomy : this.taxonomys) {
                List childs = TaxonomyQuery.me().findListByModuleAndType(this.moduleName, taxonomy.getType());
                if (childs == null || childs.size() <= 0) continue;
                ModelSorter.sort((List)childs, (BigInteger)taxonomy.getId());
                BigInteger[] newIds = Arrays.copyOf(taxonomyIds, taxonomyIds.length + childs.size());
                for (int i = taxonomyIds.length; i < newIds.length; ++i) {
                    newIds[i] = ((Taxonomy)childs.get(i - taxonomyIds.length)).getId();
                }
                taxonomyIds = newIds;
            }
        }
        Page page = ContentQuery.me().paginateInNormal(this.pageNumber, pagesize, this.moduleName, taxonomyIds, this.orderBy);
        this.setVariable("page", page);
        this.setVariable("contents", page.getList());
        ContentPaginateTag pagination = new ContentPaginateTag(this.request, (Page<Content>)page, this.moduleName, this.taxonomys);
        this.setVariable("pagination", pagination);
        this.renderBody();
    }

    public static class ContentPaginateTag
    extends BasePaginateTag {
        final String moduleName;
        final List<Taxonomy> taxonomys;
        final HttpServletRequest request;

        public ContentPaginateTag(HttpServletRequest request, Page<Content> page, String moduleName, List<Taxonomy> taxonomys) {
            super(page);
            this.request = request;
            this.moduleName = moduleName;
            this.taxonomys = taxonomys;
        }

        @Override
        protected String getUrl(int pageNumber) {
            String queryString;
            String url = JFinal.me().getContextPath() + "/" + this.moduleName + "-";
            if (this.taxonomys != null && this.taxonomys.size() > 0) {
                for (Taxonomy taxonomy : this.taxonomys) {
                    url = url + taxonomy.getSlug() + ",";
                }
                url = url.substring(0, url.length() - 1);
                url = url + "-" + pageNumber;
            } else {
                url = url + pageNumber;
            }
            if (ContentPaginateTag.enalbleFakeStatic()) {
                url = url + ContentPaginateTag.getFakeStaticSuffix();
            }
            if (StringUtils.isNotBlank((String)(queryString = this.request.getQueryString()))) {
                url = url + "?" + queryString;
            }
            if (StringUtils.isNotBlank((String)this.getAnchor())) {
                url = url + "#" + this.getAnchor();
            }
            return url;
        }
    }
}

