/*
 * Decompiled with CFR 0.152.
 */
package io.jpress.ui.freemarker.tag;

import com.jfinal.core.JFinal;
import com.jfinal.plugin.activerecord.Page;
import io.jpress.core.render.freemarker.BasePaginateTag;
import io.jpress.core.render.freemarker.JTag;
import io.jpress.model.Content;
import io.jpress.model.query.ContentQuery;
import io.jpress.utils.StringUtils;
import java.math.BigInteger;
import javax.servlet.http.HttpServletRequest;

public class IndexPageTag
extends JTag {
    public static final String TAG_NAME = "jp.indexPage";
    int pageNumber;
    String pagePara;
    String orderBy;
    HttpServletRequest request;

    public IndexPageTag(HttpServletRequest request, String pagePara, int pageNumber, String orderBy) {
        this.pagePara = pagePara;
        if (pageNumber < 1) {
            pageNumber = 1;
        }
        this.pageNumber = pageNumber;
        this.request = request;
        this.orderBy = orderBy;
    }

    @Override
    public void onRender() {
        this.orderBy = StringUtils.isBlank((String)this.orderBy) ? this.getParam("orderBy") : this.orderBy;
        String keyword = this.getParam("keyword");
        int pagesize = this.getParamToInt("pageSize", 10);
        BigInteger[] typeIds = this.getParamToBigIntegerArray("typeId");
        String[] modules = this.getParamToStringArray("module");
        String status = this.getParam("status", Content.STATUS_NORMAL);
        Page page = ContentQuery.me().paginate(this.pageNumber, pagesize, modules, keyword, status, typeIds, null, this.orderBy);
        this.setVariable("page", page);
        this.setVariable("contents", page.getList());
        IndexPaginateTag pagination = new IndexPaginateTag(this.request, (Page<Content>)page, this.pagePara);
        this.setVariable("pagination", pagination);
        this.renderBody();
    }

    public static class IndexPaginateTag
    extends BasePaginateTag {
        String pagePara;
        HttpServletRequest request;

        public IndexPaginateTag(HttpServletRequest request, Page<Content> page, String pagePara) {
            super(page);
            this.request = request;
            this.pagePara = pagePara;
        }

        @Override
        protected String getUrl(int pageNumber) {
            String queryString;
            String url = JFinal.me().getContextPath() + "/";
            url = StringUtils.isNotBlank((String)this.pagePara) ? url + this.pagePara + "-" + pageNumber : url + pageNumber;
            if (IndexPaginateTag.enalbleFakeStatic()) {
                url = url + IndexPaginateTag.getFakeStaticSuffix();
            }
            if (StringUtils.isNotBlank((String)(queryString = this.request.getQueryString()))) {
                url = url + "?" + queryString;
            }
            if (StringUtils.isNotBlank((String)this.getAnchor())) {
                url = url + "#" + this.getAnchor();
            }
            return url;
        }
    }
}

