/*
 * Decompiled with CFR 0.152.
 */
package io.jpress.ui.freemarker.tag;

import com.jfinal.core.JFinal;
import io.jpress.core.render.freemarker.JTag;
import io.jpress.model.Content;
import io.jpress.model.ModelSorter;
import io.jpress.model.Taxonomy;
import io.jpress.model.query.ContentQuery;
import io.jpress.model.router.TaxonomyRouter;
import io.jpress.model.vo.NavigationMenu;
import io.jpress.utils.StringUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class MenusTag
extends JTag {
    public static final String TAG_NAME = "jp.menus";
    private List<Taxonomy> currentTaxonomys;
    private Content currentContent;
    private HttpServletRequest request;

    public MenusTag(HttpServletRequest request) {
        this.request = request;
    }

    public MenusTag(HttpServletRequest request, List<Taxonomy> taxonomys, Content content) {
        this.request = request;
        this.currentTaxonomys = taxonomys;
        this.currentContent = content;
    }

    public MenusTag(HttpServletRequest request, Taxonomy taxonomy) {
        this.request = request;
        this.currentTaxonomys = new ArrayList<Taxonomy>();
        this.currentTaxonomys.add(taxonomy);
    }

    @Override
    public void onRender() {
        BigInteger parentId = this.getParamToBigInteger("parentId");
        String activeClass = this.getParam("activeClass", "active");
        List list = ContentQuery.me().findByModule("menu", parentId, "order_number ASC");
        if (list == null || list.isEmpty()) {
            this.renderText("");
            return;
        }
        this.setActiveMenu(list);
        if (parentId == null) {
            ModelSorter.tree((List)list);
        }
        ArrayList<NavigationMenu> menulist = new ArrayList<NavigationMenu>();
        for (Content c : list) {
            menulist.add(new NavigationMenu(c, activeClass));
        }
        this.setVariable("menus", menulist);
        this.renderBody();
    }

    private void setActiveMenu(List<Content> menuContentList) {
        for (Content menuContent : menuContentList) {
            menuContent.remove("active");
            if (menuContent.getText() == null || !menuContent.getText().equals(StringUtils.urlDecode((String)this.request.getRequestURI()))) continue;
            menuContent.put("active", (Object)"active");
        }
        if (this.currentContent != null) {
            String contentUrl = this.currentContent.getUrl();
            for (Content menuContent : menuContentList) {
                String onlyModuleUrl;
                if (contentUrl != null && contentUrl.equals(menuContent.getText())) {
                    menuContent.put("active", (Object)"active");
                }
                if (!(onlyModuleUrl = JFinal.me().getContextPath() + "/" + this.currentContent.getModule()).equals(menuContent.getText())) continue;
                menuContent.put("active", (Object)"active");
            }
        }
        if (this.currentTaxonomys == null || this.currentTaxonomys.isEmpty()) {
            return;
        }
        for (Taxonomy taxonomy : this.currentTaxonomys) {
            String routerWithoutPageNumber = TaxonomyRouter.getRouterWithoutPageNumber((Taxonomy)taxonomy);
            routerWithoutPageNumber = JFinal.me().getContextPath() + routerWithoutPageNumber;
            if (!StringUtils.isNotBlank((String)routerWithoutPageNumber)) continue;
            for (Content menuContent : menuContentList) {
                String onlyModuleUrl;
                if (menuContent.getText() != null && menuContent.getText().startsWith(StringUtils.urlDecode((String)routerWithoutPageNumber))) {
                    menuContent.put("active", (Object)"active");
                }
                if (!(onlyModuleUrl = JFinal.me().getContextPath() + "/" + taxonomy.getContentModule()).equals(menuContent.getText())) continue;
                menuContent.put("active", (Object)"active");
            }
        }
    }
}

