/*
 * Decompiled with CFR 0.152.
 */
package io.jpress.ui.freemarker.tag;

import com.jfinal.core.JFinal;
import com.jfinal.plugin.activerecord.Page;
import io.jpress.core.render.freemarker.BasePaginateTag;
import io.jpress.core.render.freemarker.JTag;
import io.jpress.plugin.search.SearcherBean;
import io.jpress.plugin.search.SearcherKit;
import io.jpress.utils.StringUtils;

public class SearchResultPageTag
extends JTag {
    public static final String TAG_NAME = "jp.searchResultPage";
    int pageNumber;
    String moduleName;
    String keyword;

    public SearchResultPageTag(String keyword, String moduleName, int pageNumber) {
        this.pageNumber = pageNumber;
        this.moduleName = moduleName;
        this.keyword = keyword;
    }

    @Override
    public void onRender() {
        int pagesize = this.getParamToInt("pageSize", 10);
        Page page = SearcherKit.search((String)this.keyword, (String)this.moduleName, (int)this.pageNumber, (int)pagesize);
        this.setVariable("page", page);
        this.setVariable("searcherBeans", page.getList());
        MyPaginateTag pagination = new MyPaginateTag((Page<SearcherBean>)page, this.keyword, this.moduleName);
        this.setVariable("pagination", pagination);
        this.renderBody();
    }

    public static class MyPaginateTag
    extends BasePaginateTag {
        final String keyword;
        final String moduleName;

        public MyPaginateTag(Page<SearcherBean> page, String keyword, String moduleName) {
            super(page);
            this.keyword = keyword;
            this.moduleName = moduleName;
        }

        @Override
        protected String getUrl(int pageNumber) {
            String url = JFinal.me().getContextPath() + "/s?";
            url = url + "m=" + (StringUtils.isNotBlank((String)this.moduleName) ? this.moduleName.trim() : "");
            url = url + "&k=" + StringUtils.urlDecode((String)this.keyword);
            url = url + "&p=" + pageNumber;
            if (StringUtils.isNotBlank((String)this.getAnchor())) {
                url = url + "#" + this.getAnchor();
            }
            return url;
        }
    }
}

