/*
 * Decompiled with CFR 0.152.
 */
package io.jpress.ui.freemarker.tag;

import com.jfinal.core.JFinal;
import com.jfinal.plugin.activerecord.Page;
import io.jpress.core.render.freemarker.BasePaginateTag;
import io.jpress.core.render.freemarker.JTag;
import io.jpress.model.Content;
import io.jpress.model.query.ContentQuery;
import io.jpress.utils.StringUtils;
import java.math.BigInteger;

public class UserContentPageTag
extends JTag {
    public static final String TAG_NAME = "jp.userContentPage";
    BigInteger userId;
    int pageNumber;
    String action;

    public UserContentPageTag(String action, BigInteger userId, int pageNumber) {
        this.userId = userId;
        this.pageNumber = pageNumber;
        this.action = action;
    }

    @Override
    public void onRender() {
        BigInteger[] bigIntegerArray;
        String module = this.getParam("module");
        BigInteger taxonomyId = this.getParamToBigInteger("taxonomyId");
        int pageSize = this.getParamToInt("pageSize", 10);
        String orderby = this.getParam("orderBy");
        String status = this.getParam("status", Content.STATUS_NORMAL);
        if (taxonomyId == null) {
            bigIntegerArray = null;
        } else {
            BigInteger[] bigIntegerArray2 = new BigInteger[1];
            bigIntegerArray = bigIntegerArray2;
            bigIntegerArray2[0] = taxonomyId;
        }
        BigInteger[] tids = bigIntegerArray;
        Page page = ContentQuery.me().paginate(this.pageNumber, pageSize, module, null, status, tids, this.userId, orderby);
        this.setVariable("page", page);
        this.setVariable("contents", page.getList());
        MyPaginateTag pagination = new MyPaginateTag((Page<Content>)page, this.action);
        this.setVariable("pagination", pagination);
        this.renderBody();
    }

    public static class MyPaginateTag
    extends BasePaginateTag {
        final String action;

        public MyPaginateTag(Page<Content> page, String action) {
            super(page);
            this.action = action;
        }

        @Override
        protected String getUrl(int pageNumber) {
            String url = JFinal.me().getContextPath() + "/user/center/";
            url = url + this.action;
            url = url + "-" + pageNumber;
            if (StringUtils.isNotBlank((String)this.getAnchor())) {
                url = url + "#" + this.getAnchor();
            }
            return url;
        }
    }
}

