/*
 * Decompiled with CFR 0.152.
 */
package io.jpress.wechat;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;
import com.jfinal.core.Controller;
import io.jpress.model.query.OptionQuery;
import io.jpress.utils.StringUtils;
import javax.servlet.http.HttpServletRequest;

public class WechatUserInterceptor
implements Interceptor {
    public static final String AUTHORIZE_URL = "https://open.weixin.qq.com/connect/oauth2/authorize?appid={appid}&redirect_uri={redirecturi}&response_type=code&scope=snsapi_userinfo&state=235#wechat_redirect";

    public void intercept(Invocation inv) {
        Controller controller = inv.getController();
        String userJson = (String)inv.getController().getSessionAttr("_wechat_user");
        if (StringUtils.isBlank((String)userJson)) {
            inv.invoke();
            return;
        }
        String appid = OptionQuery.me().findValue("wechat_appid");
        if (StringUtils.isBlank((String)appid)) {
            inv.invoke();
            return;
        }
        HttpServletRequest request = controller.getRequest();
        String queryString = request.getQueryString();
        String toUrl = request.getRequestURI();
        if (StringUtils.isNotBlank((String)queryString)) {
            toUrl = toUrl.concat("?").concat(queryString);
        }
        toUrl = StringUtils.urlEncode((String)toUrl);
        String redirectUrl = request.getScheme() + "://" + request.getServerName() + "/wechat/callback?goto=" + toUrl;
        redirectUrl = StringUtils.urlEncode((String)redirectUrl);
        String url = AUTHORIZE_URL.replace("{redirecturi}", redirectUrl).replace("{appid}", appid.trim());
        controller.redirect(url);
    }
}

