/*
 * Decompiled with CFR 0.152.
 */
package io.jpress.wechat.processer;

import com.jfinal.weixin.sdk.msg.in.InMsg;
import com.jfinal.weixin.sdk.msg.out.News;
import com.jfinal.weixin.sdk.msg.out.OutMsg;
import com.jfinal.weixin.sdk.msg.out.OutNewsMsg;
import com.jfinal.weixin.sdk.msg.out.OutTextMsg;
import io.jpress.model.Content;
import io.jpress.model.query.ContentQuery;
import io.jpress.model.query.OptionQuery;
import io.jpress.utils.StringUtils;
import io.jpress.wechat.IMessageProcesser;
import io.jpress.wechat.MessageProcesser;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

@MessageProcesser(key="contents")
public class ContentsProcesser
implements IMessageProcesser {
    List<BigInteger> contentIds;

    @Override
    public void onInit(String configInfo) {
        String[] ids;
        if (StringUtils.isBlank((String)configInfo)) {
            return;
        }
        this.contentIds = new ArrayList<BigInteger>();
        for (String id : ids = configInfo.split(",")) {
            try {
                this.contentIds.add(new BigInteger(id.trim()));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    @Override
    public OutMsg process(InMsg message) {
        String domain = OptionQuery.me().findValue("web_domain");
        if (StringUtils.isBlank((String)domain)) {
            OutTextMsg otm = new OutTextMsg(message);
            otm.setContent("\u60a8\u8fd8\u6ca1\u6709\u914d\u7f6e\u60a8\u7684\u57df\u540d\uff0c\u8bf7\u5148\u5728\u540e\u53f0\u7684\u3010\u8bbe\u7f6e\u3011>\u3010\u5e38\u89c4\u3011\u91cc\u914d\u7f6e\u60a8\u7684\u7f51\u7ad9\u57df\u540d\uff01");
            return otm;
        }
        if (this.contentIds == null || this.contentIds.isEmpty()) {
            OutTextMsg otm = new OutTextMsg(message);
            otm.setContent("\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u6dfb\u52a0\u6b63\u786e\u7684\u5185\u5bb9ID\u3002");
            return otm;
        }
        ArrayList<Content> contents = new ArrayList<Content>();
        if (this.contentIds != null && this.contentIds.size() > 0) {
            for (BigInteger id : this.contentIds) {
                contents.add(ContentQuery.me().findById(id));
            }
        }
        if (contents.isEmpty()) {
            OutTextMsg otm = new OutTextMsg(message);
            otm.setContent("\u914d\u7f6e\u9519\u8bef\uff0c\u6682\u672a\u627e\u5230\u76f8\u5e94\u5185\u5bb9\uff01\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            return otm;
        }
        OutNewsMsg out = new OutNewsMsg(message);
        for (Content content : contents) {
            News news = new News();
            news.setTitle(content.getTitle());
            news.setDescription(content.getSummary());
            news.setPicUrl(domain + content.getImage());
            news.setUrl(domain + content.getUrl());
            out.addNews(news);
        }
        return out;
    }
}

