/*
 * Decompiled with CFR 0.152.
 */
package io.jpress.core.cache;

import com.jfinal.kit.PropKit;
import com.jfinal.plugin.ehcache.CacheKit;
import io.jpress.utils.RequestUtils;
import javax.servlet.http.HttpServletRequest;

/*
 * Exception performing whole class analysis ignored.
 */
public class ActionCacheManager {
    private static String USE_JCACHE = "_use_jcache__";
    private static String USE_JCACHE_KEY = "_use_jcache_key__";
    private static String USE_JCACHE_CONTENT_TYPE = "_use_jcache_content_type__";
    public static String CACHE_NAME = "action";
    public static String CACHE_NAME_WECHAT = "action_wechat";
    public static String CACHE_NAME_MOBILE = "action_mobile";
    private static Boolean isClose;

    public static void clearCache() {
        if (ActionCacheManager.isCloseActionCache()) {
            return;
        }
        CacheKit.removeAll((String)CACHE_NAME);
        CacheKit.removeAll((String)CACHE_NAME_WECHAT);
        CacheKit.removeAll((String)CACHE_NAME_MOBILE);
    }

    public static boolean isCloseActionCache() {
        if (isClose == null) {
            isClose = PropKit.getBoolean((String)"close_action_cache", (Boolean)false);
        }
        return isClose;
    }

    public static String getCache(HttpServletRequest request, String key) {
        if (RequestUtils.isWechatBrowser((HttpServletRequest)request)) {
            return (String)CacheKit.get((String)CACHE_NAME_WECHAT, (Object)key);
        }
        if (RequestUtils.isMoblieBrowser((HttpServletRequest)request)) {
            return (String)CacheKit.get((String)CACHE_NAME_MOBILE, (Object)key);
        }
        return (String)CacheKit.get((String)CACHE_NAME, (Object)key);
    }

    public static void putCache(HttpServletRequest request, Object value) {
        if (RequestUtils.isWechatBrowser((HttpServletRequest)request)) {
            CacheKit.put((String)CACHE_NAME_WECHAT, (Object)ActionCacheManager.getCacheKey((HttpServletRequest)request), (Object)value);
        } else if (RequestUtils.isMoblieBrowser((HttpServletRequest)request)) {
            CacheKit.put((String)CACHE_NAME_MOBILE, (Object)ActionCacheManager.getCacheKey((HttpServletRequest)request), (Object)value);
        } else {
            CacheKit.put((String)CACHE_NAME, (Object)ActionCacheManager.getCacheKey((HttpServletRequest)request), (Object)value);
        }
    }

    public static void enableCache(HttpServletRequest request) {
        request.setAttribute(USE_JCACHE, (Object)true);
    }

    public static boolean isEnableCache(HttpServletRequest request) {
        return (Boolean)(request.getAttribute(USE_JCACHE) == null ? Boolean.valueOf(false) : request.getAttribute(USE_JCACHE));
    }

    public static void setCacheKey(HttpServletRequest request, String key) {
        request.setAttribute(USE_JCACHE_KEY, (Object)key);
    }

    public static String getCacheKey(HttpServletRequest request) {
        return (String)request.getAttribute(USE_JCACHE_KEY);
    }

    public static void setCacheContentType(HttpServletRequest request, String contentType) {
        request.setAttribute(USE_JCACHE_CONTENT_TYPE, (Object)contentType);
    }

    public static String getCacheContentType(HttpServletRequest request) {
        return (String)request.getAttribute(USE_JCACHE_CONTENT_TYPE);
    }
}

