/*
 * Decompiled with CFR 0.152.
 */
package io.jpress.core.render.freemarker;

import com.jfinal.plugin.activerecord.Page;
import io.jpress.core.render.freemarker.BasePaginateTag;
import io.jpress.core.render.freemarker.JTag;
import io.jpress.model.query.OptionQuery;
import io.jpress.utils.StringUtils;
import java.util.ArrayList;

public abstract class BasePaginateTag
extends JTag {
    final Page<?> page;
    private String previousClass;
    private String nextClass;
    private String activeClass;
    private String disabledClass;
    private String anchor;
    private boolean onlyShowPreviousAndNext = false;

    public BasePaginateTag(Page<?> page) {
        this.page = page;
    }

    public void onRender() {
        int endPage;
        this.previousClass = this.getParam("previousClass", "previous");
        this.nextClass = this.getParam("nextClass", "next");
        this.activeClass = this.getParam("activeClass", "active");
        this.disabledClass = this.getParam("disabledClass", "disabled");
        this.anchor = this.getParam("anchor");
        this.onlyShowPreviousAndNext = this.getParamToBool("onlyShowPreviousAndNext", Boolean.valueOf(false));
        String previousText = this.getParam("previousText", "\u4e0a\u4e00\u9875");
        String nextText = this.getParam("nextText", "\u4e0b\u4e00\u9875");
        int currentPage = this.page.getPageNumber();
        int totalPage = this.page.getTotalPage();
        if (totalPage <= 0 || currentPage > totalPage) {
            return;
        }
        int startPage = currentPage - 4;
        if (startPage < 1) {
            startPage = 1;
        }
        if ((endPage = currentPage + 4) > totalPage) {
            endPage = totalPage;
        }
        if (currentPage <= 8) {
            startPage = 1;
        }
        if (totalPage - currentPage < 8) {
            endPage = totalPage;
        }
        ArrayList<PaginateItem> pages = new ArrayList<PaginateItem>();
        if (currentPage == 1) {
            pages.add(new PaginateItem(this.previousClass + " " + this.disabledClass, "javascript:;", previousText));
        } else {
            pages.add(new PaginateItem(this.previousClass, this.getUrl(currentPage - 1), previousText));
        }
        if (currentPage > 8 && !this.onlyShowPreviousAndNext) {
            pages.add(new PaginateItem("", this.getUrl(1), "1"));
            pages.add(new PaginateItem("", this.getUrl(2), "2"));
            pages.add(new PaginateItem(this.disabledClass, "javascript:;", "..."));
        }
        if (!this.onlyShowPreviousAndNext) {
            for (int i = startPage; i <= endPage; ++i) {
                if (currentPage == i) {
                    pages.add(new PaginateItem(this.activeClass, "javascript:;", i));
                    continue;
                }
                pages.add(new PaginateItem("", this.getUrl(i), i));
            }
        }
        if (totalPage - currentPage >= 8 && !this.onlyShowPreviousAndNext) {
            pages.add(new PaginateItem(this.disabledClass, "javascript:;", "..."));
            pages.add(new PaginateItem("", this.getUrl(totalPage - 1), totalPage - 1));
            pages.add(new PaginateItem("", this.getUrl(totalPage), totalPage));
        }
        if (currentPage == totalPage) {
            pages.add(new PaginateItem(this.nextClass + " " + this.disabledClass, "javascript:;", nextText));
        } else {
            pages.add(new PaginateItem(this.nextClass, this.getUrl(currentPage + 1), nextText));
        }
        this.setVariable("pages", pages);
        this.renderBody();
    }

    protected static boolean enalbleFakeStatic() {
        Boolean fakeStaticEnable = OptionQuery.me().findValueAsBool("router_fakestatic_enable");
        return fakeStaticEnable != null && fakeStaticEnable == true;
    }

    protected static String getFakeStaticSuffix() {
        String fakeStaticSuffix = OptionQuery.me().findValue("router_fakestatic_suffix");
        if (StringUtils.isNotBlank((String)fakeStaticSuffix)) {
            return fakeStaticSuffix.trim();
        }
        return ".html";
    }

    public Page<?> getPage() {
        return this.page;
    }

    public String getPrevious() {
        return this.previousClass;
    }

    public String getNext() {
        return this.nextClass;
    }

    public String getDisabled() {
        return this.disabledClass;
    }

    public String getAnchor() {
        return this.anchor;
    }

    protected abstract String getUrl(int var1);
}

