/*
 * Decompiled with CFR 0.152.
 */
package io.jpress.core.render.freemarker;

import com.jfinal.log.Log;
import com.jfinal.render.FreeMarkerRender;
import freemarker.core.Environment;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNumberModel;
import freemarker.template.TemplateScalarModel;
import java.io.IOException;
import java.io.Writer;
import java.math.BigInteger;
import java.util.Map;

public abstract class JTag
implements TemplateDirectiveModel {
    private static final Log log = Log.getLog(JTag.class);
    private Environment mEnv;
    private Map<?, ?> mParams;
    private TemplateModel[] mTemplateModels;
    private TemplateDirectiveBody mBody;

    public void execute(Environment env, Map params, TemplateModel[] templateModels, TemplateDirectiveBody body) throws TemplateException, IOException {
        this.mEnv = env;
        this.mParams = params;
        this.mTemplateModels = templateModels;
        this.mBody = body;
        this.onRender();
    }

    public abstract void onRender();

    protected void setVariable(String key, Object value) {
        try {
            this.mEnv.setVariable(key, FreeMarkerRender.getConfiguration().getObjectWrapper().wrap(value));
        }
        catch (TemplateModelException e) {
            log.error("setVariable(String key,Object value) is error!", (Throwable)e);
        }
    }

    protected void renderText(String text) {
        try {
            this.mEnv.getOut().write(text == null ? "null" : text);
        }
        catch (IOException e) {
            log.error("JTag renderText error", (Throwable)e);
        }
    }

    protected void renderBody() {
        try {
            this.mBody.render(this.mEnv.getOut());
        }
        catch (TemplateException e) {
            log.error("JTag renderBody is error!", (Throwable)e);
        }
        catch (IOException e) {
            log.error("JTag renderBody is error!", (Throwable)e);
        }
    }

    protected void renderBody(Writer writer) {
        try {
            this.mBody.render(writer);
        }
        catch (TemplateException e) {
            log.error("JTag renderBody(Writer writer) is error!", (Throwable)e);
        }
        catch (IOException e) {
            log.error("JTag renderBody(Writer writer) is error!", (Throwable)e);
        }
    }

    public TemplateModel[] getTemplateModels() {
        return this.mTemplateModels;
    }

    public TemplateDirectiveBody getBody() {
        return this.mBody;
    }

    public Writer getWriter() {
        return this.mEnv.getOut();
    }

    public String getParam(String key, String defaultValue) {
        String value = this.getParam(key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public String getParam(String key) {
        TemplateModel model = (TemplateModel)this.mParams.get(key);
        if (model == null) {
            return null;
        }
        try {
            if (model instanceof TemplateScalarModel) {
                return ((TemplateScalarModel)model).getAsString();
            }
            if (model instanceof TemplateNumberModel) {
                return ((TemplateNumberModel)model).getAsNumber().toString();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public Long getParamToLong(String key, long defaultValue) {
        Long value = this.getParamToLong(key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public Long getParamToLong(String key) {
        TemplateModel model = (TemplateModel)this.mParams.get(key);
        if (model == null) {
            return null;
        }
        try {
            if (model instanceof TemplateNumberModel) {
                return ((TemplateNumberModel)model).getAsNumber().longValue();
            }
            if (model instanceof TemplateScalarModel) {
                String string = ((TemplateScalarModel)model).getAsString();
                if (null == string || "".equals(string.trim())) {
                    return null;
                }
                return Long.parseLong(string);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("must number!", e);
        }
        return null;
    }

    public BigInteger getParamToBigInteger(String key, BigInteger defaultValue) {
        BigInteger value = this.getParamToBigInteger(key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public BigInteger getParamToBigInteger(String key) {
        TemplateModel model = (TemplateModel)this.mParams.get(key);
        if (model == null) {
            return null;
        }
        try {
            if (model instanceof TemplateNumberModel) {
                long number = ((TemplateNumberModel)model).getAsNumber().longValue();
                return BigInteger.valueOf(number);
            }
            if (model instanceof TemplateScalarModel) {
                String string = ((TemplateScalarModel)model).getAsString();
                if (null == string || "".equals(string.trim())) {
                    return null;
                }
                return new BigInteger(string);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("must number!", e);
        }
        return null;
    }

    public Integer getParamToInt(String key, Integer defaultValue) {
        Integer value = this.getParamToInt(key);
        if (null != value) {
            return value;
        }
        return defaultValue;
    }

    public Integer getParamToInt(String key) {
        TemplateModel model = (TemplateModel)this.mParams.get(key);
        if (model == null) {
            return null;
        }
        try {
            if (model instanceof TemplateNumberModel) {
                return ((TemplateNumberModel)model).getAsNumber().intValue();
            }
            if (model instanceof TemplateScalarModel) {
                String string = ((TemplateScalarModel)model).getAsString();
                if (null == string || "".equals(string.trim())) {
                    return null;
                }
                return Integer.parseInt(string);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("must number!", e);
        }
        return null;
    }

    public Integer[] getParamToIntArray(String key) {
        String string = this.getParam(key);
        if (null == string || "".equals(string.trim())) {
            return null;
        }
        if (!string.contains(",")) {
            return new Integer[]{Integer.valueOf(string.trim())};
        }
        String[] array = string.split(",");
        Integer[] ids = new Integer[array.length];
        int i = 0;
        for (String str : array) {
            ids[i++] = Integer.valueOf(str.trim());
        }
        return ids;
    }

    public Long[] getParamToLongArray(String key) {
        String string = this.getParam(key);
        if (null == string || "".equals(string.trim())) {
            return null;
        }
        if (!string.contains(",")) {
            return new Long[]{Long.valueOf(string.trim())};
        }
        String[] array = string.split(",");
        Long[] ids = new Long[array.length];
        int i = 0;
        for (String str : array) {
            ids[i++] = Long.valueOf(str.trim());
        }
        return ids;
    }

    public BigInteger[] getParamToBigIntegerArray(String key) {
        String string = this.getParam(key);
        if (null == string || "".equals(string.trim())) {
            return null;
        }
        if (!string.contains(",")) {
            return new BigInteger[]{new BigInteger(string.trim())};
        }
        String[] array = string.split(",");
        BigInteger[] ids = new BigInteger[array.length];
        int i = 0;
        for (String str : array) {
            ids[i++] = new BigInteger(str.trim());
        }
        return ids;
    }

    public String[] getParamToStringArray(String key) {
        String string = this.getParam(key);
        if (null == string || "".equals(string.trim())) {
            return null;
        }
        if (!string.contains(",")) {
            return new String[]{string};
        }
        return string.split(",");
    }

    public Boolean getParamToBool(String key, Boolean defaultValue) {
        Boolean value = this.getParamToBool(key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public Boolean getParamToBool(String key) {
        TemplateModel model = (TemplateModel)this.mParams.get(key);
        if (model == null) {
            return null;
        }
        try {
            if (model instanceof TemplateBooleanModel) {
                return ((TemplateBooleanModel)model).getAsBoolean();
            }
            if (model instanceof TemplateNumberModel) {
                return ((TemplateNumberModel)model).getAsNumber().intValue() != 0;
            }
            if (model instanceof TemplateScalarModel) {
                String string = ((TemplateScalarModel)model).getAsString();
                if (null != string && !"".equals(string.trim())) {
                    return !string.equals("0") && !string.equalsIgnoreCase("false");
                }
                return null;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("param must is \"0\",\"1\"  or \"true\",\"false\"", e);
        }
        return null;
    }
}

