/*
 * Decompiled with CFR 0.152.
 */
package io.jpress.install;

import com.jfinal.aop.Before;
import com.jfinal.kit.StrKit;
import com.jfinal.log.Log;
import io.jpress.core.JBaseController;
import io.jpress.install.InstallInterceptor;
import io.jpress.install.InstallUtils;
import io.jpress.router.RouterMapping;
import io.jpress.utils.EncryptUtils;
import io.jpress.utils.StringUtils;
import java.sql.SQLException;
import java.util.List;

@RouterMapping(url="/install", viewPath="/WEB-INF/install")
@Before(value={InstallInterceptor.class})
public class InstallController
extends JBaseController {
    private static final Log log = Log.getLog(InstallController.class);

    public void index() {
        this.render("step1.html");
    }

    public void step2() {
        List tableList;
        String db_host = this.getPara("db_host");
        String db_host_port = this.getPara("db_host_port");
        db_host_port = StringUtils.isNotBlank((String)db_host_port) ? db_host_port.trim() : "3306";
        String db_name = this.getPara("db_name");
        String db_user = this.getPara("db_user");
        String db_password = this.getPara("db_password");
        String db_table_prefix = this.getPara("db_tablePrefix");
        if (!StrKit.notBlank((String[])new String[]{db_host, db_host_port, db_name, db_user})) {
            this.render("step2.html");
            return;
        }
        InstallUtils.init((String)db_host, (String)db_host_port, (String)db_name, (String)db_user, (String)db_password, (String)db_table_prefix);
        try {
            tableList = InstallUtils.getTableList();
            if (null != tableList && tableList.size() > 0 && (tableList.contains(db_table_prefix + "attachment") || tableList.contains(db_table_prefix + "comment") || tableList.contains(db_table_prefix + "content") || tableList.contains(db_table_prefix + "mapping") || tableList.contains(db_table_prefix + "metadata") || tableList.contains(db_table_prefix + "option") || tableList.contains(db_table_prefix + "taxonomy") || tableList.contains(db_table_prefix + "user"))) {
                this.redirect("/install/step2_error");
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.redirect("/install/step2_error");
            return;
        }
        try {
            InstallUtils.createJpressDatabase();
            tableList = InstallUtils.getTableList();
            if (null != tableList && tableList.size() > 0 && tableList.contains(db_table_prefix + "attachment") && tableList.contains(db_table_prefix + "comment") && tableList.contains(db_table_prefix + "content") && tableList.contains(db_table_prefix + "mapping") && tableList.contains(db_table_prefix + "metadata") && tableList.contains(db_table_prefix + "option") && tableList.contains(db_table_prefix + "taxonomy") && tableList.contains(db_table_prefix + "user")) {
                this.redirect("/install/step3");
                return;
            }
        }
        catch (Exception e) {
            log.error("InstallController step2 is erro", (Throwable)e);
        }
        this.redirect("/install/step2_error");
    }

    public void step2_error() {
        this.render("step2_error.html");
    }

    public void step3() throws SQLException {
        String webname = this.getPara("webname");
        String username = this.getPara("username");
        String password = this.getPara("password");
        if (StrKit.isBlank((String)webname) || StrKit.isBlank((String)username) || StrKit.isBlank((String)password)) {
            this.keepPara();
            this.render("step3.html");
            return;
        }
        InstallUtils.setWebName((String)webname);
        String salt = EncryptUtils.salt();
        password = EncryptUtils.encryptPassword((String)password, (String)salt);
        InstallUtils.setWebFirstUser((String)username, (String)password, (String)salt);
        InstallUtils.createDbProperties();
        InstallUtils.createJpressProperties();
        this.redirect("/");
    }
}

