/*
 * Decompiled with CFR 0.152.
 */
package io.jpress.listener;

import io.jpress.message.Message;
import io.jpress.message.MessageListener;
import io.jpress.message.annotation.Listener;
import io.jpress.model.User;
import io.jpress.model.query.OptionQuery;
import io.jpress.notify.email.Email;
import io.jpress.notify.email.EmailSenderFactory;
import io.jpress.utils.StringUtils;

@Listener(action={"user:add"})
public class AdminNotificationListener
implements MessageListener {
    public void onMessage(Message message) {
        if ("user:add".equals(message.getAction())) {
            this.notify(message);
        }
    }

    private void notify(Message message) {
        Object temp = message.getData();
        if (temp == null && !(temp instanceof User)) {
            return;
        }
        User user = (User)temp;
        this.notifyAuthor(user);
    }

    private void notifyAuthor(User registedUser) {
        this.notifyByEmail(registedUser);
    }

    private void notifyByEmail(User registedUser) {
        Boolean notify = OptionQuery.me().findValueAsBool("notify_admin_by_email_when_user_registed");
        if (notify != null && notify.booleanValue()) {
            String toemail = OptionQuery.me().findValue("web_administrator_email");
            if (StringUtils.isBlank((String)toemail)) {
                return;
            }
            Email email = new Email();
            email.subject("\u60a8\u7684\u7f51\u7ad9\u6709\u4eba\u6ce8\u518c\u4e86\uff01");
            String content = OptionQuery.me().findValue("notify_admin_by_content_email_when_user_registed");
            if (!StringUtils.isNotBlank((String)content)) {
                content = "\u60a8\u7684\u7f51\u7ad9\u6709\u4eba\u6ce8\u518c\u4e86\uff01";
            }
            email.content(content);
            email.to(new String[]{toemail});
            EmailSenderFactory.createSender().send(email);
        }
    }
}

