/*
 * Decompiled with CFR 0.152.
 */
package io.jpress.listener;

import io.jpress.message.Message;
import io.jpress.message.MessageListener;
import io.jpress.message.annotation.Listener;
import io.jpress.model.Comment;
import io.jpress.model.Content;
import io.jpress.model.query.CommentQuery;
import io.jpress.model.query.ContentQuery;

@Listener(action={"comment:add", "comment:update", "comment:delete"})
public class CommentListener
implements MessageListener {
    public void onMessage(Message message) {
        if ("comment:add".equals(message.getAction())) {
            this.updateContentCommentCount(message);
            this.updateCommentCount(message);
        } else if ("comment:update".equals(message.getAction())) {
            this.updateContentCommentCount(message);
            this.updateCommentCount(message);
        } else if ("comment:delete".equals(message.getAction())) {
            this.updateContentCommentCount(message);
            this.updateCommentCount(message);
        }
    }

    private void updateContentCommentCount(Message message) {
        Content content;
        Comment comment = (Comment)message.getData();
        if (comment != null && comment.getContentId() != null && (content = ContentQuery.me().findById(comment.getContentId())) != null) {
            content.updateCommentCount();
        }
    }

    private void updateCommentCount(Message message) {
        Comment parentComment;
        Comment comment = (Comment)message.getData();
        if (comment != null && comment.getParentId() != null && (parentComment = CommentQuery.me().findById((Object)comment.getParentId())) != null) {
            parentComment.updateCommentCount();
        }
    }
}

