/*
 * Decompiled with CFR 0.152.
 */
package io.jpress.menu;

import io.jpress.core.addon.HookInvoker;
import io.jpress.menu.MenuGroup;
import io.jpress.message.MessageKit;
import io.jpress.utils.StringUtils;
import java.util.LinkedList;

public class MenuManager {
    public static final String ACTION_INIT_MENU = "_INIT_MENU";
    static MenuManager manager = new MenuManager();
    static final LinkedList<MenuGroup> menuGroups = new LinkedList();

    public static MenuManager me() {
        return manager;
    }

    public String generateHtml() {
        if (menuGroups.isEmpty()) {
            MessageKit.sendMessage((String)ACTION_INIT_MENU, (Object)this);
        }
        HookInvoker.menuInitBefore((MenuManager)this);
        StringBuilder htmlBuilder = new StringBuilder();
        for (MenuGroup group : menuGroups) {
            htmlBuilder.append(group.generateHtml());
        }
        HookInvoker.menuInitAfter((MenuManager)this);
        return htmlBuilder.toString();
    }

    public void refresh() {
        menuGroups.clear();
    }

    public void addMenuGroup(MenuGroup gourp) {
        menuGroups.add(gourp);
    }

    public void addMenuGroup(int index, MenuGroup gourp) {
        menuGroups.add(index, gourp);
    }

    public void removeMenuGroupById(String id) {
        if (StringUtils.isBlank((String)id)) {
            return;
        }
        MenuGroup deleteGroup = null;
        for (MenuGroup menuGroup : menuGroups) {
            if (!id.equals(menuGroup.getId())) continue;
            deleteGroup = menuGroup;
            break;
        }
        if (deleteGroup != null) {
            menuGroups.remove(deleteGroup);
        }
    }

    public MenuGroup getMenuGroupById(String id) {
        if (StringUtils.isBlank((String)id)) {
            return null;
        }
        for (MenuGroup menuGroup : menuGroups) {
            if (!id.equals(menuGroup.getId())) continue;
            return menuGroup;
        }
        return null;
    }

    public LinkedList<MenuGroup> getMenuGroups() {
        return menuGroups;
    }
}

