/*
 * Decompiled with CFR 0.152.
 */
package io.jpress.notify.email;

import com.jfinal.log.Log;
import io.jpress.model.query.OptionQuery;
import io.jpress.notify.email.Email;
import io.jpress.notify.email.IEmailSender;
import java.util.HashSet;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;

/*
 * Exception performing whole class analysis ignored.
 */
public class SimplerEmailSender
extends Authenticator
implements IEmailSender {
    private static final Log logger = Log.getLog(SimplerEmailSender.class);
    private String host;
    private String name;
    private String password;
    private boolean useSSL = true;

    private void init() {
        this.host = OptionQuery.me().findValue("email_host");
        this.name = OptionQuery.me().findValue("email_username");
        this.password = OptionQuery.me().findValue("email_password");
        this.useSSL = Boolean.parseBoolean(OptionQuery.me().findValue("email_usessl"));
    }

    private Message createMessage() {
        this.init();
        Properties props = new Properties();
        props.setProperty("mail.transport.protocol", "smtp");
        props.setProperty("mail.smtp.auth", "true");
        props.setProperty("mail.smtp.host", this.host);
        props.setProperty("mail.smtp.port", "25");
        if (this.useSSL) {
            props.put("mail.smtp.starttls.enable", "true");
            props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            props.setProperty("mail.smtp.port", "465");
        }
        props.setProperty("mail.smtp.localhost", "127.0.0.1");
        Session session = Session.getInstance((Properties)props, (Authenticator)this);
        MimeMessage message = new MimeMessage(session);
        try {
            message.setFrom((Address)new InternetAddress(MimeUtility.encodeText((String)this.name) + "<" + this.name + ">"));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return message;
    }

    protected PasswordAuthentication getPasswordAuthentication() {
        return new PasswordAuthentication(this.name, this.password);
    }

    private static Address[] toAddress(String ... emails) {
        if (emails == null || emails.length == 0) {
            return null;
        }
        HashSet<InternetAddress> addSet = new HashSet<InternetAddress>();
        for (String email : emails) {
            try {
                addSet.add(new InternetAddress(email));
            }
            catch (AddressException e) {
                // empty catch block
            }
        }
        return addSet.toArray(new Address[0]);
    }

    public void send(Email email) {
        Message message = this.createMessage();
        try {
            message.setSubject(email.getSubject());
            message.setContent((Object)email.getContent(), "text/html;charset=utf-8");
            message.setRecipients(Message.RecipientType.TO, SimplerEmailSender.toAddress((String[])email.getTo()));
            message.setRecipients(Message.RecipientType.CC, SimplerEmailSender.toAddress((String[])email.getCc()));
            Transport.send((Message)message);
        }
        catch (MessagingException e) {
            logger.error("SimplerEmailSender send error", (Throwable)e);
        }
    }
}

