/*
 * Decompiled with CFR 0.152.
 */
package io.jpress.ui.freemarker.tag;

import com.jfinal.plugin.activerecord.Page;
import io.jpress.core.render.freemarker.JTag;
import io.jpress.model.ModelSorter;
import io.jpress.model.Taxonomy;
import io.jpress.model.query.ContentQuery;
import io.jpress.model.query.TaxonomyQuery;
import io.jpress.ui.freemarker.tag.ContentPageTag;
import io.jpress.utils.StringUtils;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class ContentPageTag
extends JTag {
    public static final String TAG_NAME = "jp.contentPage";
    int pageNumber;
    String moduleName;
    String orderBy;
    List<Taxonomy> taxonomys;
    HttpServletRequest request;

    public ContentPageTag(HttpServletRequest request, int pageNumber, String moduleName, List<Taxonomy> taxonomys, String orderBy) {
        this.request = request;
        this.pageNumber = pageNumber;
        this.moduleName = moduleName;
        this.taxonomys = taxonomys;
        this.orderBy = orderBy;
    }

    public void onRender() {
        boolean containChild;
        int pagesize = this.getParamToInt("pageSize", Integer.valueOf(10));
        this.orderBy = StringUtils.isBlank((String)this.orderBy) ? this.getParam("orderBy") : this.orderBy;
        BigInteger[] taxonomyIds = null;
        if (this.taxonomys != null && this.taxonomys.size() > 0) {
            taxonomyIds = new BigInteger[this.taxonomys.size()];
            for (int i = 0; i < taxonomyIds.length; ++i) {
                taxonomyIds[i] = ((Taxonomy)this.taxonomys.get(i)).getId();
            }
        }
        if (taxonomyIds != null && taxonomyIds.length > 0 && (containChild = this.getParamToBool("containChild", Boolean.valueOf(false)).booleanValue())) {
            for (Taxonomy taxonomy : this.taxonomys) {
                List childs = TaxonomyQuery.me().findListByModuleAndType(this.moduleName, taxonomy.getType());
                if (childs == null || childs.size() <= 0) continue;
                ModelSorter.sort((List)childs, (BigInteger)taxonomy.getId());
                BigInteger[] newIds = Arrays.copyOf(taxonomyIds, taxonomyIds.length + childs.size());
                for (int i = taxonomyIds.length; i < newIds.length; ++i) {
                    newIds[i] = ((Taxonomy)childs.get(i - taxonomyIds.length)).getId();
                }
                taxonomyIds = newIds;
            }
        }
        Page page = ContentQuery.me().paginateInNormal(this.pageNumber, pagesize, this.moduleName, taxonomyIds, this.orderBy);
        this.setVariable("page", (Object)page);
        this.setVariable("contents", (Object)page.getList());
        ContentPaginateTag pagination = new ContentPaginateTag(this.request, page, this.moduleName, this.taxonomys);
        this.setVariable("pagination", (Object)pagination);
        this.renderBody();
    }
}

