/*
 * Decompiled with CFR 0.152.
 */
package io.jpress.wechat;

import com.jfinal.log.Log;
import com.jfinal.weixin.sdk.msg.in.InMsg;
import com.jfinal.weixin.sdk.msg.out.OutMsg;
import io.jpress.utils.ClassUtils;
import io.jpress.utils.StringUtils;
import io.jpress.wechat.IMessageProcesser;
import io.jpress.wechat.MessageProcesser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProcesserManager {
    private static final Log log = Log.getLog(ProcesserManager.class);
    private static Map<String, Class<? extends IMessageProcesser>> map = new HashMap();
    private static ProcesserManager me;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ProcesserManager me() {
        if (me != null) return me;
        Class<ProcesserManager> clazz = ProcesserManager.class;
        synchronized (ProcesserManager.class) {
            me = new ProcesserManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return me;
        }
    }

    private ProcesserManager() {
        List clist = ClassUtils.scanSubClass(IMessageProcesser.class, (boolean)true);
        if (clist != null && clist.size() > 0) {
            for (Class clazz : clist) {
                this.registerProcesser(clazz);
            }
        }
    }

    public OutMsg invoke(String replyContent, InMsg message) {
        IMessageProcesser processer = this.getProcesser(replyContent);
        return processer == null ? null : processer.process(message);
    }

    public void registerProcesser(Class<? extends IMessageProcesser> clazz) {
        MessageProcesser reply = clazz.getAnnotation(MessageProcesser.class);
        if (null != reply && StringUtils.isNotBlank((String)reply.key())) {
            map.put("[" + reply.key() + "]", clazz);
        }
    }

    private IMessageProcesser getProcesser(String replyContent) {
        String key = replyContent.substring(0, replyContent.indexOf("]") + 1);
        String config = replyContent.substring(replyContent.indexOf("]") + 1);
        Class clazz = (Class)map.get(key);
        if (clazz == null) {
            return null;
        }
        try {
            IMessageProcesser processer = (IMessageProcesser)clazz.newInstance();
            processer.onInit(config);
            return processer;
        }
        catch (Exception e) {
            log.warn("wechat ProcesserInvoker getProcesser error", (Throwable)e);
            return null;
        }
    }
}

