/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric;

import android.app.Application;
import android.content.pm.PackageManager;
import org.robolectric.res.ResourceLoader;
import org.robolectric.res.builder.RobolectricPackageManager;
import org.robolectric.util.Scheduler;

public class RuntimeEnvironment {
    public static Application application;
    private static volatile Thread mainThread;
    private static String qualifiers;
    private static Object activityThread;
    private static RobolectricPackageManager packageManager;
    private static int apiLevel;
    private static Scheduler masterScheduler;
    private static ResourceLoader systemResourceLoader;
    private static ResourceLoader appResourceLoader;

    public static boolean isMainThread(Thread thread) {
        return thread == mainThread;
    }

    public static boolean isMainThread() {
        return RuntimeEnvironment.isMainThread(Thread.currentThread());
    }

    public static Thread getMainThread() {
        return mainThread;
    }

    public static void setMainThread(Thread newMainThread) {
        mainThread = newMainThread;
    }

    public static Object getActivityThread() {
        return activityThread;
    }

    public static void setActivityThread(Object newActivityThread) {
        activityThread = newActivityThread;
    }

    public static PackageManager getPackageManager() {
        return (PackageManager)packageManager;
    }

    public static RobolectricPackageManager getRobolectricPackageManager() {
        return packageManager;
    }

    public static void setRobolectricPackageManager(RobolectricPackageManager newPackageManager) {
        if (packageManager != null) {
            packageManager.reset();
        }
        packageManager = newPackageManager;
    }

    public static String getQualifiers() {
        return qualifiers;
    }

    public static void setQualifiers(String newQualifiers) {
        qualifiers = newQualifiers;
    }

    public static void setApiLevel(int level) {
        apiLevel = level;
    }

    public static int getApiLevel() {
        return apiLevel;
    }

    public static Scheduler getMasterScheduler() {
        return masterScheduler;
    }

    public static void setMasterScheduler(Scheduler masterScheduler) {
        RuntimeEnvironment.masterScheduler = masterScheduler;
    }

    public static void setSystemResourceLoader(ResourceLoader systemResourceLoader) {
        RuntimeEnvironment.systemResourceLoader = systemResourceLoader;
    }

    public static void setAppResourceLoader(ResourceLoader appResourceLoader) {
        RuntimeEnvironment.appResourceLoader = appResourceLoader;
    }

    public static ResourceLoader getSystemResourceLoader() {
        return systemResourceLoader;
    }

    public static ResourceLoader getAppResourceLoader() {
        return appResourceLoader;
    }

    static {
        mainThread = Thread.currentThread();
    }
}

