/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.robolectric.res.ResName;
import org.robolectric.res.ResourceIndex;

public class MergedResourceIndex
extends ResourceIndex {
    private final ResourceIndex[] subIndexes;
    private final Set<String> actualPackageNames = new HashSet<String>();

    public MergedResourceIndex(ResourceIndex ... subIndexes) {
        this.subIndexes = subIndexes;
        for (ResourceIndex subIndex : subIndexes) {
            this.actualPackageNames.addAll(subIndex.getPackages());
            MergedResourceIndex.merge(this.resourceNameToId, subIndex.resourceNameToId, "resourceNameToId");
            MergedResourceIndex.merge(this.resourceIdToResName, subIndex.resourceIdToResName, "resourceIdToResName");
        }
    }

    private static <K, V> void merge(Map<K, V> map1, Map<K, V> map2, String name) {
        int expected = map1.size() + map2.size();
        map1.putAll(map2);
        if (map1.size() != expected) {
            throw new IllegalStateException("there must have been some overlap for " + name + "! expected " + expected + " but got " + map1.size());
        }
    }

    @Override
    public Integer getResourceId(ResName resName) {
        Integer id = (Integer)this.resourceNameToId.get(resName);
        if (id == null) {
            for (ResourceIndex subIndex : this.subIndexes) {
                id = subIndex.getResourceId(resName);
                if (id == null) continue;
                return id;
            }
        }
        return id;
    }

    @Override
    public ResName getResName(int resourceId) {
        ResName resName = (ResName)this.resourceIdToResName.get(resourceId);
        if (resName == null) {
            for (ResourceIndex subIndex : this.subIndexes) {
                resName = subIndex.getResName(resourceId);
                if (resName == null) continue;
                return resName;
            }
        }
        return resName;
    }

    @Override
    public Collection<String> getPackages() {
        return this.actualPackageNames;
    }
}

