/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.robolectric.res.Plural;
import org.robolectric.res.ResBundle;
import org.robolectric.res.XmlLoader;
import org.robolectric.res.XpathResourceXmlLoader;

public class PluralResourceLoader
extends XpathResourceXmlLoader {
    private ResBundle<PluralRules> pluralRulesResBundle;

    public PluralResourceLoader(ResBundle<PluralRules> pluralRulesResBundle) {
        super("/resources/plurals");
        this.pluralRulesResBundle = pluralRulesResBundle;
    }

    @Override
    protected void processNode(String name, XpathResourceXmlLoader.XmlNode xmlNode, XmlLoader.XmlContext xmlContext) throws XPathExpressionException {
        PluralRules rules = new PluralRules();
        for (XpathResourceXmlLoader.XmlNode item : xmlNode.selectElements("item")) {
            String value = item.getTextContent();
            String quantity = item.getAttrValue("quantity");
            rules.add(new Plural(quantity, value));
        }
        this.pluralRulesResBundle.put("plurals", name, rules, xmlContext);
    }

    static class PluralRules {
        List<Plural> plurals = new ArrayList<Plural>();

        PluralRules() {
        }

        Plural find(int quantity) {
            for (Plural p : this.plurals) {
                if (p.num != quantity) continue;
                return p;
            }
            for (Plural p : this.plurals) {
                if (p.num != -1) continue;
                return p;
            }
            return null;
        }

        void add(Plural p) {
            this.plurals.add(p);
        }
    }
}

