/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import java.util.ArrayList;
import org.robolectric.res.StringResources;
import org.robolectric.res.TypedResource;
import org.robolectric.res.XpathResourceXmlLoader;

public enum ResType {
    DRAWABLE,
    ATTR_DATA,
    BOOLEAN,
    COLOR,
    COLOR_STATE_LIST,
    DIMEN,
    FILE,
    FLOAT,
    FRACTION,
    INTEGER,
    LAYOUT,
    STYLE{

        @Override
        public TypedResource getValueWithType(XpathResourceXmlLoader.XmlNode xmlNode) {
            throw new UnsupportedOperationException();
        }
    }
    ,
    CHAR_SEQUENCE{

        @Override
        public TypedResource getValueWithType(XpathResourceXmlLoader.XmlNode xmlNode) {
            return new TypedResource<String>(StringResources.proccessStringResources(xmlNode.getTextContent()), this);
        }
    }
    ,
    CHAR_SEQUENCE_ARRAY{

        @Override
        public TypedResource getValueWithType(XpathResourceXmlLoader.XmlNode xmlNode) {
            return ResType.extractScalarItems(xmlNode, 3.CHAR_SEQUENCE_ARRAY, 3.CHAR_SEQUENCE);
        }
    }
    ,
    INTEGER_ARRAY{

        @Override
        public TypedResource getValueWithType(XpathResourceXmlLoader.XmlNode xmlNode) {
            return ResType.extractScalarItems(xmlNode, 4.INTEGER_ARRAY, 4.INTEGER);
        }
    };


    private static TypedResource extractScalarItems(XpathResourceXmlLoader.XmlNode xmlNode, ResType arrayResType, ResType itemResType) {
        ArrayList<TypedResource<String>> items = new ArrayList<TypedResource<String>>();
        for (XpathResourceXmlLoader.XmlNode item : xmlNode.selectElements("item")) {
            items.add(new TypedResource<String>(item.getTextContent(), itemResType));
        }
        TypedResource[] typedResources = items.toArray(new TypedResource[items.size()]);
        return new TypedResource<TypedResource[]>(typedResources, arrayResType);
    }

    public TypedResource getValueWithType(XpathResourceXmlLoader.XmlNode xmlNode) {
        return new TypedResource<String>(xmlNode.getTextContent(), this);
    }
}

