/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import java.util.Arrays;
import org.robolectric.res.FsFile;

public class ResourcePath {
    public final String packageName;
    public final FsFile resourceBase;
    public final FsFile assetsDir;
    public Class<?>[] rClasses;

    public ResourcePath(String packageName, FsFile resourceBase, FsFile assetsDir, Class<?> ... rClasses) {
        this.packageName = packageName;
        this.resourceBase = resourceBase;
        this.assetsDir = assetsDir;
        this.rClasses = rClasses;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String toString() {
        return "ResourcePath{package=" + this.getPackageName() + ", path=" + this.resourceBase + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourcePath that = (ResourcePath)o;
        if (this.packageName != null ? !this.packageName.equals(that.packageName) : that.packageName != null) {
            return false;
        }
        if (this.resourceBase != null ? !this.resourceBase.equals(that.resourceBase) : that.resourceBase != null) {
            return false;
        }
        if (this.assetsDir != null ? !this.assetsDir.equals(that.assetsDir) : that.assetsDir != null) {
            return false;
        }
        return Arrays.equals(this.rClasses, that.rClasses);
    }

    public int hashCode() {
        int result = this.packageName != null ? this.packageName.hashCode() : 0;
        result = 31 * result + (this.resourceBase != null ? this.resourceBase.hashCode() : 0);
        result = 31 * result + (this.assetsDir != null ? this.assetsDir.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.rClasses);
        return result;
    }
}

