/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import java.io.InputStream;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.robolectric.res.DrawableNode;
import org.robolectric.res.MergedResourceIndex;
import org.robolectric.res.Plural;
import org.robolectric.res.ResName;
import org.robolectric.res.ResourceIndex;
import org.robolectric.res.ResourceLoader;
import org.robolectric.res.TypedResource;
import org.robolectric.res.XResourceLoader;
import org.robolectric.res.builder.XmlBlock;

public class RoutingResourceLoader
extends ResourceLoader {
    private final Map<String, ResourceLoader> resourceLoaders;
    private final ResourceIndex resourceIndex;

    public RoutingResourceLoader(Map<String, ResourceLoader> resourceLoaders) {
        this.resourceLoaders = resourceLoaders;
        HashSet<ResourceIndex> resourceIndexes = new HashSet<ResourceIndex>();
        for (ResourceLoader resourceLoader : resourceLoaders.values()) {
            resourceIndexes.add(resourceLoader.getResourceIndex());
        }
        this.resourceIndex = new MergedResourceIndex(resourceIndexes.toArray(new ResourceIndex[resourceIndexes.size()]));
    }

    @Override
    public TypedResource getValue(@NotNull ResName resName, String qualifiers) {
        return this.pickFor(resName).getValue(resName, qualifiers);
    }

    @Override
    public Plural getPlural(ResName resName, int quantity, String qualifiers) {
        return this.pickFor(resName).getPlural(resName, quantity, qualifiers);
    }

    @Override
    public XmlBlock getXml(ResName resName, String qualifiers) {
        return this.pickFor(resName).getXml(resName, qualifiers);
    }

    @Override
    public DrawableNode getDrawableNode(ResName resName, String qualifiers) {
        return this.pickFor(resName).getDrawableNode(resName, qualifiers);
    }

    @Override
    public InputStream getRawValue(ResName resName) {
        return this.pickFor(resName).getRawValue(resName);
    }

    @Override
    public ResourceIndex getResourceIndex() {
        return this.resourceIndex;
    }

    @Override
    public boolean providesFor(String namespace) {
        return this.whichProvidesFor(namespace) != null;
    }

    private ResourceLoader pickFor(int id) {
        ResName resName = this.resourceIndex.getResName(id);
        return this.pickFor(resName);
    }

    private ResourceLoader pickFor(ResName resName) {
        if (resName == null) {
            return new NullResourceLoader();
        }
        return this.pickFor(resName.packageName);
    }

    private ResourceLoader pickFor(String namespace) {
        if (namespace.equals("android.internal")) {
            return new NullResourceLoader();
        }
        ResourceLoader resourceLoader = this.resourceLoaders.get(namespace);
        if (resourceLoader == null) {
            resourceLoader = this.whichProvidesFor(namespace);
            if (resourceLoader != null) {
                return resourceLoader;
            }
            throw new RuntimeException("no ResourceLoader found for " + namespace);
        }
        return resourceLoader;
    }

    private ResourceLoader whichProvidesFor(String namespace) {
        for (ResourceLoader loader : this.resourceLoaders.values()) {
            if (!loader.providesFor(namespace)) continue;
            return loader;
        }
        return null;
    }

    private static class NullResourceLoader
    extends XResourceLoader {
        public NullResourceLoader() {
            super(null);
        }

        @Override
        void doInitialize() {
        }

        @Override
        public boolean providesFor(String namespace) {
            return true;
        }
    }
}

