/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import java.util.LinkedHashMap;
import java.util.Map;
import org.robolectric.res.AttributeResource;
import org.robolectric.res.ResName;
import org.robolectric.res.Style;
import org.robolectric.util.Strings;

public class StyleData
implements Style {
    private final String packageName;
    private final String name;
    private final String parent;
    private final Map<ResName, AttributeResource> items = new LinkedHashMap<ResName, AttributeResource>();

    public StyleData(String packageName, String name, String parent) {
        this.packageName = packageName;
        this.name = name;
        this.parent = parent;
    }

    public String getName() {
        return this.name;
    }

    public String getParent() {
        return this.parent;
    }

    public void add(ResName attrName, AttributeResource attribute) {
        attrName.mustBe("attr");
        this.items.put(attrName, attribute);
    }

    @Override
    public AttributeResource getAttrValue(ResName resName) {
        return this.items.get(resName);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StyleData)) {
            return false;
        }
        StyleData other = (StyleData)obj;
        return Strings.equals((String)this.packageName, (String)other.packageName) && Strings.equals((String)this.name, (String)other.name) && Strings.equals((String)this.parent, (String)other.parent) && this.items.size() == other.items.size();
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + Strings.nullToEmpty((String)this.packageName).hashCode();
        hashCode = 31 * hashCode + Strings.nullToEmpty((String)this.name).hashCode();
        hashCode = 31 * hashCode + Strings.nullToEmpty((String)this.parent).hashCode();
        hashCode = 31 * hashCode + this.items.size();
        return hashCode;
    }

    public String toString() {
        return "StyleData{name='" + this.name + '\'' + ", parent='" + this.parent + '\'' + '}';
    }

    public String getPackageName() {
        return this.packageName;
    }
}

