/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import com.ximpleware.VTDNav;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.robolectric.res.FsFile;
import org.robolectric.res.XpathResourceXmlLoader;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public abstract class XmlLoader {
    private static final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    private DocumentBuilder documentBuilder;

    public synchronized Document parse(FsFile xmlFile) {
        InputStream inputStream = null;
        try {
            if (this.documentBuilder == null) {
                this.documentBuilder = documentBuilderFactory.newDocumentBuilder();
            }
            inputStream = xmlFile.getInputStream();
            Document document = this.documentBuilder.parse(inputStream);
            return document;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    protected void processResourceXml(FsFile xmlFile, VTDNav vtdNav, String packageName) throws Exception {
        this.processResourceXml(xmlFile, new XpathResourceXmlLoader.XmlNode(vtdNav), new XmlContext(packageName, xmlFile));
    }

    protected abstract void processResourceXml(FsFile var1, XpathResourceXmlLoader.XmlNode var2, XmlContext var3) throws Exception;

    static {
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setIgnoringComments(true);
        documentBuilderFactory.setIgnoringElementContentWhitespace(true);
    }

    public static class XmlContext {
        public static final Pattern DIR_QUALIFIER_PATTERN = Pattern.compile("^[^-]+(?:-(.*))?$");
        public final String packageName;
        private final FsFile xmlFile;

        public XmlContext(String packageName, FsFile xmlFile) {
            this.packageName = packageName;
            this.xmlFile = xmlFile;
        }

        public String getDirPrefix() {
            String parentDir = this.xmlFile.getParent().getName();
            return parentDir.split("-")[0];
        }

        public String getQualifiers() {
            String parentDir = this.xmlFile.getParent().getName();
            Matcher matcher = DIR_QUALIFIER_PATTERN.matcher(parentDir);
            if (!matcher.find()) {
                throw new IllegalStateException(parentDir);
            }
            return matcher.group(1);
        }

        public FsFile getXmlFile() {
            return this.xmlFile;
        }

        public String toString() {
            return "XmlContext{packageName='" + this.packageName + '\'' + ", xmlFile=" + this.xmlFile + '}';
        }
    }
}

