/*
 * Decompiled with CFR 0.152.
 */
package com.hsuns.token.operator;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.hsuns.token.config.TokenConfig;
import com.hsuns.token.operator.AbstractTokenOperator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class MemoryTokenOperator
extends AbstractTokenOperator {
    private static LoadingCache<String, Object> CONTAINER;

    public MemoryTokenOperator(TokenConfig config) {
        super(config);
        CacheBuilder builder = CacheBuilder.newBuilder();
        builder.expireAfterWrite(config.getExpiredTimeInMinutes(), TimeUnit.MINUTES);
        if (config.isAutoDelay()) {
            builder.expireAfterAccess(config.getExpiredTimeInMinutes(), TimeUnit.MINUTES);
        }
        CONTAINER = builder.build((CacheLoader)new CacheLoader<String, Object>(){

            public Object load(String key) throws Exception {
                return null;
            }
        });
    }

    @Override
    public String add(Object value) {
        String key = this.config.getKeyGenerator().key();
        CONTAINER.put((Object)key, value);
        return key;
    }

    @Override
    public Object get(String token) {
        return CONTAINER.getIfPresent((Object)token);
    }

    @Override
    public List<Object> values() {
        return new ArrayList<Object>(CONTAINER.asMap().values());
    }

    @Override
    public Map<String, Object> all() {
        return CONTAINER.asMap();
    }

    @Override
    public boolean delay(String token) {
        try {
            CONTAINER.get((Object)token);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean invalidate(String token) {
        CONTAINER.invalidate((Object)token);
        return true;
    }
}

