/*
 * Decompiled with CFR 0.152.
 */
package com.hsuns.token.redis;

import com.hsuns.token.redis.RedisTokenProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisConfiguration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@Configuration
@EnableConfigurationProperties(value={RedisTokenProperties.class})
public class RedisTokenAutoConfiguration {
    @Autowired
    private RedisTokenProperties properties;

    @Bean
    public RedisConfiguration configuration() {
        switch (this.properties.getType()) {
            case "sentinel": {
                RedisSentinelConfiguration sentinelConfiguration = new RedisSentinelConfiguration();
                sentinelConfiguration.setPassword(this.properties.getPassword());
                return sentinelConfiguration;
            }
            case "cluster": {
                RedisClusterConfiguration clusterConfiguration = new RedisClusterConfiguration();
                clusterConfiguration.setPassword(this.properties.getPassword());
                return clusterConfiguration;
            }
        }
        RedisStandaloneConfiguration standaloneConfiguration = new RedisStandaloneConfiguration();
        standaloneConfiguration.setHostName(this.properties.getStandaloneHost());
        standaloneConfiguration.setPort(this.properties.getStandalonePort());
        standaloneConfiguration.setPassword(this.properties.getPassword());
        return standaloneConfiguration;
    }

    @Bean
    public RedisConnectionFactory connectionFactory(RedisConfiguration configuration) {
        JedisConnectionFactory factory = null;
        if (configuration instanceof RedisStandaloneConfiguration) {
            factory = new JedisConnectionFactory((RedisStandaloneConfiguration)configuration);
        } else if (configuration instanceof RedisSentinelConfiguration) {
            factory = new JedisConnectionFactory((RedisSentinelConfiguration)configuration);
        } else if (configuration instanceof RedisClusterConfiguration) {
            factory = new JedisConnectionFactory((RedisClusterConfiguration)configuration);
        }
        return factory;
    }

    @Bean
    public RedisTemplate<String, String> redisTemplate(RedisConnectionFactory connectionFactory) {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setConnectionFactory(connectionFactory);
        redisTemplate.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        redisTemplate.setValueSerializer((RedisSerializer)new StringRedisSerializer());
        return redisTemplate;
    }
}

