package com.rabbit.blade.compiler;

import javax.annotation.processing.Filer;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

/**
 * <b>Description : </b>
 * <p>Created by <a href="mailto:fjd@xdja.com">fanjiandong</a> on 2016/12/2 20:20.</p>
 */

public abstract class BladeTypeElement {

    private final TypeElement typeElement;

    public TypeElement getTypeElement() {
        return this.typeElement;
    }

    public BladeTypeElement(TypeElement typeElement) throws ProcessingException {
        this.typeElement = typeElement;
    }

    /**
     * 首字母小写
     *
     * @param s 待转字符串
     * @return 首字母小写字符串
     */
    public String lowerFirstLetter(String s) {
        if (!Character.isUpperCase(s.charAt(0))) return s;
        return String.valueOf((char) (s.charAt(0) + 32)) + s.substring(1);
    }

    public abstract void generateCode(Elements elementUtils, Filer filer);
}
