/*
 * Decompiled with CFR 0.152.
 */
package com.rabbit.blade.presenter.assist;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import com.rabbit.blade.presenter.assist.Loader;

public class DialogLoader
implements Loader {
    private final Activity activity;
    private ProgressDialog loadingDialog;

    public DialogLoader(@NonNull Activity activity) {
        this.activity = activity;
        this.loadingDialog = new ProgressDialog((Context)this.activity);
        this.loadingDialog.setProgressStyle(0);
        this.loadingDialog.setCancelable(true);
        this.loadingDialog.setCanceledOnTouchOutside(false);
    }

    @Override
    public void loadingMessage(@Nullable String msg, boolean isCancelable, @Nullable DialogInterface.OnCancelListener cancelListener) {
        this.loadingDialog.setMessage((CharSequence)msg);
        this.loadingDialog.setCancelable(isCancelable);
        if (isCancelable) {
            this.loadingDialog.setOnCancelListener(cancelListener);
        }
        if (!this.loadingDialog.isShowing()) {
            this.loadingDialog.show();
        }
    }

    @Override
    public void loadingMessage(@StringRes int resId, boolean isCancelable, @Nullable DialogInterface.OnCancelListener cancelListener) {
        String msg = this.activity.getString(resId);
        this.loadingMessage(msg, isCancelable, cancelListener);
    }

    @Override
    public void cancel() {
        if (this.loadingDialog != null && this.loadingDialog.isShowing()) {
            this.loadingDialog.dismiss();
        }
    }
}

