/*
 * Decompiled with CFR 0.152.
 */
package com.rabbit.blade.presenter.gui.mvp;

import android.app.Activity;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.rabbit.blade.comm.util.LogUtil;
import com.rabbit.blade.presenter.gui.mvp.annotation.MVP;
import com.rabbit.blade.presenter.gui.mvp.presenter.Presenter;
import com.rabbit.blade.presenter.gui.mvp.view.ActivityView;
import com.rabbit.blade.presenter.gui.mvp.view.FragmentView;
import com.rabbit.blade.presenter.gui.mvp.view.Vu;

public class MvpBuilder {
    public static void buildActivity(@NonNull Activity activity, @NonNull Bundle savedInstanceState) {
        ActivityMvpConstraint constraint = (ActivityMvpConstraint)activity;
        constraint.preMvpBinding(savedInstanceState);
        MVP.ACTIVITY mvpBinderAnn = activity.getClass().getAnnotation(MVP.ACTIVITY.class);
        Presenter presenter = MvpBuilder.getPresenter(mvpBinderAnn != null && mvpBinderAnn.presentable(), activity, constraint);
        Vu.ActivityVu[] views = MvpBuilder.getActivityVus(mvpBinderAnn, constraint);
        if (presenter != null && views != null) {
            for (Vu.ActivityVu view : views) {
                presenter.bindVu(view);
            }
        }
        if (views != null) {
            for (Vu.ActivityVu view : views) {
                if (view == null) continue;
                view.bindPresenter(presenter);
                view.bindActivity(activity);
                view.initView(savedInstanceState);
            }
        }
        constraint.afterMvpBinding(savedInstanceState);
    }

    public static View buildFragment(Fragment fragment, LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        FragmentMvpConstraint binder = (FragmentMvpConstraint)fragment;
        binder.preMvpBinding(savedInstanceState);
        MVP.FRAGMENT mvpBinderAnn = fragment.getClass().getAnnotation(MVP.FRAGMENT.class);
        Presenter presenter = MvpBuilder.getPresenter(mvpBinderAnn != null && mvpBinderAnn.presentable(), fragment, binder);
        Vu.FragmentVu view = MvpBuilder.getFragmentVu(mvpBinderAnn, binder);
        if (presenter != null) {
            presenter.bindVu(view);
        }
        if (view != null) {
            view.bindPresenter(presenter);
            view.bindFragment(fragment);
            View targetView = view.initView(inflater, container, savedInstanceState);
            binder.afterMvpBinding(savedInstanceState);
            return targetView;
        }
        binder.afterMvpBinding(savedInstanceState);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Vu.ActivityVu[] getActivityVus(MVP.ACTIVITY mvpBinderAnn, ActivityMvpConstraint binder) {
        Vu.ActivityVu[] views = null;
        try {
            Class<? extends Vu.ActivityVu>[] vClses;
            if (mvpBinderAnn != null && (vClses = mvpBinderAnn.views()).length > 0) {
                views = new Vu.ActivityVu[vClses.length];
                for (int i = 0; i < vClses.length; ++i) {
                    Class<? extends Vu.ActivityVu> vCls = vClses[i];
                    if (vCls == null || vCls.getName().equals(ActivityView.class.getName())) continue;
                    views[i] = vCls.newInstance();
                }
            }
        }
        catch (Exception e) {
            LogUtil.getUtils().w((Object)e.getMessage());
        }
        finally {
            if (views == null) {
                views = binder.provideVus();
            }
        }
        return views;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Vu.FragmentVu getFragmentVu(MVP.FRAGMENT mvpBinderAnn, FragmentMvpConstraint binder) {
        Vu.FragmentVu view = null;
        try {
            Class<? extends Vu.FragmentVu> vCls;
            if (mvpBinderAnn != null && !(vCls = mvpBinderAnn.view()).getName().equals(FragmentView.class.getName())) {
                view = vCls.newInstance();
            }
        }
        catch (Exception e) {
            LogUtil.getUtils().w((Object)e.getMessage());
        }
        finally {
            if (view == null) {
                view = binder.provideVu();
            }
        }
        return view;
    }

    private static Presenter getPresenter(boolean isPresentable, Object presenterObj, MvpConstraint constraint) {
        Presenter presenter = null;
        if (isPresentable && presenterObj instanceof Presenter) {
            presenter = (Presenter)presenterObj;
        }
        if (presenter == null) {
            presenter = constraint.providePresenter();
        }
        return presenter;
    }

    public static interface ActivityMvpConstraint
    extends MvpConstraint {
        @NonNull
        public Vu.ActivityVu[] provideVus();

        @Nullable
        public Vu.ActivityVu provideVu();
    }

    public static interface FragmentMvpConstraint
    extends MvpConstraint {
        @Nullable
        public Vu.FragmentVu provideVu();
    }

    public static interface MvpConstraint {
        public void preMvpBinding(Bundle var1);

        public void afterMvpBinding(Bundle var1);

        @Nullable
        public Presenter providePresenter();
    }
}

