/*
 * Decompiled with CFR 0.152.
 */
package com.rabbit.blade.presenter.split;

import android.app.Application;
import android.content.Context;
import android.content.res.Configuration;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.blankj.utilcode.utils.Utils;
import com.rabbit.blade.comm.util.LogUtil;
import com.rabbit.blade.presenter.split.BoundedApplication;
import com.rabbit.blade.presenter.split.ForkedApplication;
import com.rabbit.blade.presenter.split.ForkedEvent;
import java.lang.reflect.Method;
import java.util.Map;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

public final class ForkService {
    @Nullable
    public static Map<String, BoundedApplication> acquireBoundedApplications(@NonNull Context context) {
        Context applicationContext = context.getApplicationContext();
        if (applicationContext instanceof ForkedApplication) {
            ForkedApplication forkedApplication = (ForkedApplication)applicationContext;
            return forkedApplication.getBoundedApplications();
        }
        return null;
    }

    @Nullable
    public static Map<String, BoundedApplication> acquireBoundedApplications() {
        Context context = Utils.getContext();
        if (context != null) {
            return ForkService.acquireBoundedApplications(context);
        }
        return null;
    }

    public static void registerBoundedApplication(@NonNull Context context, @NonNull String tag, @NonNull BoundedApplication application) {
        Context applicationContext = context.getApplicationContext();
        if (applicationContext instanceof ForkedApplication) {
            ForkedApplication forkedApplication = (ForkedApplication)applicationContext;
            forkedApplication.putBoundedApplication(tag, application);
        }
    }

    public static void registerBoundedApplication(@NonNull String tag, @NonNull BoundedApplication application) {
        Context context = Utils.getContext();
        if (context != null) {
            ForkService.registerBoundedApplication(context, tag, application);
        }
    }

    public static void unRegisterBoundedApplication(@NonNull Context context, @NonNull String tag) {
        Context applicationContext = context.getApplicationContext();
        if (applicationContext instanceof ForkedApplication) {
            ForkedApplication forkedApplication = (ForkedApplication)applicationContext;
            forkedApplication.removeBoundedApplication(tag);
        }
    }

    public static void unRegisterBoundedApplication(@NonNull String tag) {
        Context context = Utils.getContext();
        if (context != null) {
            ForkService.unRegisterBoundedApplication(context, tag);
        }
    }

    @Nullable
    public static <T extends BoundedApplication> T findForkedApplication(@NonNull Context context, @NonNull String tag) {
        Context applicationContext = context.getApplicationContext();
        if (applicationContext instanceof ForkedApplication) {
            ForkedApplication forkedApplication = (ForkedApplication)applicationContext;
            return forkedApplication.getBoundedApplication(tag);
        }
        return null;
    }

    @Nullable
    public static <T extends BoundedApplication> T findForkedApplication(@NonNull String tag) {
        Context context = Utils.getContext();
        if (context != null) {
            return ForkService.findForkedApplication(context, tag);
        }
        return null;
    }

    public static void handleForkedEvent(@NonNull BoundedApplication boundedApplication, @NonNull ForkedEvent forkedEvent) {
        switch (forkedEvent.getLifeCycle()) {
            case "onAttach": {
                boundedApplication.onAttach((Application)forkedEvent.getObject());
                break;
            }
            case "onConfigurationChanged": {
                boundedApplication.onConfigurationChanged((Configuration)forkedEvent.getObject());
                break;
            }
            case "onLowMemory": {
                boundedApplication.onLowMemory();
                break;
            }
            case "onTerminate": {
                boundedApplication.onTerminate();
                break;
            }
            case "onTrimMemory": {
                boundedApplication.onTrimMemory((Integer)forkedEvent.getObject());
                break;
            }
            case "onDetach": {
                boundedApplication.onDetach();
                break;
            }
        }
    }

    public static <T> boolean checkForkedEventSubscriber(Class<T> forkedClass) {
        Method method = null;
        try {
            method = forkedClass.getMethod("handleForkedEvent", ForkedEvent.class);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        if (method == null) {
            LogUtil.getUtils().w((Object)("The class " + forkedClass.getSimpleName() + "  must override with method \"handleForkedEvent\""));
            return false;
        }
        Subscribe annotation = method.getAnnotation(Subscribe.class);
        if (annotation == null) {
            LogUtil.getUtils().w((Object)"\"handleForkedEvent\" method must annotation with \"@Subscribe\"");
            return false;
        }
        ThreadMode threadMode = annotation.threadMode();
        int priority = annotation.priority();
        boolean sticky = annotation.sticky();
        LogUtil.getUtils().d((Object)("\"handleForkedEvent\" \"@Subscribe\" annotation threadMode : " + threadMode));
        LogUtil.getUtils().d((Object)("\"handleForkedEvent\" \"@Subscribe\" annotation priority : " + priority));
        LogUtil.getUtils().d((Object)("\"handleForkedEvent\" \"@Subscribe\" annotation sticky : " + sticky));
        if (priority == 0) {
            LogUtil.getUtils().w((Object)"\"priority\" in \"@Subscribe\" annotation is default value,Are you sure? ");
        }
        if (!sticky) {
            LogUtil.getUtils().w((Object)"\"sticky\" in \"@Subscribe\" annotation is false,Are you sure? ");
        }
        return true;
    }
}

