/*
 * Decompiled with CFR 0.152.
 */
package com.sohu.tv.builder;

import com.alibaba.fastjson.JSONObject;
import com.sohu.tv.cachecloud.client.basic.heartbeat.ClientStatusEnum;
import com.sohu.tv.cachecloud.client.basic.util.ConstUtils;
import com.sohu.tv.cachecloud.client.basic.util.HttpUtils;
import com.sohu.tv.cachecloud.client.basic.util.StringUtil;
import com.sohu.tv.cachecloud.client.jedis.stat.ClientDataCollectReportExecutor;
import java.util.HashSet;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisCluster;

public class RedisClusterBuilder {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final long appId;
    private GenericObjectPoolConfig jedisPoolConfig;
    private JedisCluster jedisCluster;
    private int connectionTimeout = 2000;
    private int soTimeout = 2000;
    private int maxRedirections = 5;
    private final Lock lock = new ReentrantLock();
    private boolean clientStatIsOpen = true;

    RedisClusterBuilder() {
        this.appId = ConstUtils.APP_ID;
        GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
        poolConfig.setMaxTotal(40);
        poolConfig.setMaxIdle(16);
        poolConfig.setMinIdle(8);
        poolConfig.setMaxWaitMillis(1000L);
        poolConfig.setJmxNamePrefix("jedis-pool");
        poolConfig.setJmxEnabled(true);
        this.jedisPoolConfig = poolConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JedisCluster build() {
        if (this.jedisCluster == null) {
            while (true) {
                try {
                    String password;
                    String[] nodeArray;
                    this.lock.tryLock(10L, TimeUnit.SECONDS);
                    if (this.jedisCluster != null) {
                        JedisCluster jedisCluster = this.jedisCluster;
                        return jedisCluster;
                    }
                    String url = ConstUtils.REDIS_CLUSTER_URL;
                    String response = HttpUtils.doGet((String)url);
                    JSONObject jsonObject = null;
                    try {
                        jsonObject = JSONObject.parseObject((String)response);
                    }
                    catch (Exception e) {
                        this.logger.error("remote build error, appId: {}", (Object)this.appId, (Object)e);
                    }
                    if (jsonObject == null) {
                        this.logger.error("get cluster info for appId: {} error. continue...", (Object)this.appId);
                        continue;
                    }
                    int status = jsonObject.getIntValue("status");
                    String message = jsonObject.getString("message");
                    if (status == ClientStatusEnum.ERROR.getStatus()) {
                        throw new IllegalStateException(message);
                    }
                    if (status == ClientStatusEnum.WARN.getStatus()) {
                        this.logger.warn(message);
                    } else {
                        this.logger.info(message);
                    }
                    HashSet<HostAndPort> nodeList = new HashSet<HostAndPort>();
                    String nodeInfo = jsonObject.getString("shardInfo");
                    nodeInfo = nodeInfo.replace(" ", ",");
                    for (String node : nodeArray = nodeInfo.split(",")) {
                        String[] ipAndPort = node.split(":");
                        if (ipAndPort.length < 2) continue;
                        String ip = ipAndPort[0];
                        int port = Integer.parseInt(ipAndPort[1]);
                        nodeList.add(new HostAndPort(ip, port));
                    }
                    if (this.clientStatIsOpen) {
                        ClientDataCollectReportExecutor.getInstance();
                    }
                    this.jedisCluster = StringUtil.isBlank((String)(password = jsonObject.getString("password"))) ? new JedisCluster(nodeList, this.connectionTimeout, this.soTimeout, this.maxRedirections, this.jedisPoolConfig) : new JedisCluster(nodeList, this.connectionTimeout, this.soTimeout, this.maxRedirections, password, this.jedisPoolConfig);
                    JedisCluster jedisCluster = this.jedisCluster;
                    return jedisCluster;
                }
                catch (Throwable e) {
                    this.logger.error(e.getMessage(), e);
                }
                finally {
                    this.lock.unlock();
                    continue;
                }
                try {
                    TimeUnit.MILLISECONDS.sleep(200 + new Random().nextInt(1000));
                }
                catch (InterruptedException e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return this.jedisCluster;
    }

    public RedisClusterBuilder setJedisPoolConfig(GenericObjectPoolConfig jedisPoolConfig) {
        this.jedisPoolConfig = jedisPoolConfig;
        return this;
    }

    public RedisClusterBuilder setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public RedisClusterBuilder setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
        return this;
    }

    public RedisClusterBuilder setMaxRedirections(int maxRedirections) {
        this.maxRedirections = maxRedirections;
        return this;
    }

    public RedisClusterBuilder setClientStatIsOpen(boolean clientStatIsOpen) {
        this.clientStatIsOpen = clientStatIsOpen;
        return this;
    }
}

