/*
 * Decompiled with CFR 0.152.
 */
package com.sohu.tv.builder;

import com.alibaba.fastjson.JSONObject;
import com.sohu.tv.cachecloud.client.basic.heartbeat.ClientStatusEnum;
import com.sohu.tv.cachecloud.client.basic.util.ConstUtils;
import com.sohu.tv.cachecloud.client.basic.util.HttpUtils;
import com.sohu.tv.cachecloud.client.basic.util.StringUtil;
import com.sohu.tv.cachecloud.client.jedis.stat.ClientDataCollectReportExecutor;
import java.util.HashSet;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.JedisSentinelPool;

public class RedisSentinelBuilder {
    private static Logger logger = LoggerFactory.getLogger(RedisSentinelBuilder.class);
    private final long appId = ConstUtils.APP_ID;
    private GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
    private int connectionTimeout = 2000;
    private int soTimeout = 2000;
    private volatile JedisSentinelPool sentinelPool;
    private static final Lock LOCK = new ReentrantLock();
    private boolean clientStatIsOpen = true;

    RedisSentinelBuilder() {
        this.poolConfig.setMaxTotal(24);
        this.poolConfig.setMaxIdle(16);
        this.poolConfig.setMinIdle(0);
        this.poolConfig.setMaxWaitMillis(1000L);
        this.poolConfig.setJmxNamePrefix("jedis-sentinel-pool");
        this.poolConfig.setJmxEnabled(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JedisSentinelPool build() {
        if (this.sentinelPool == null) {
            while (true) {
                block20: {
                    try {
                        String password;
                        LOCK.tryLock(10L, TimeUnit.MILLISECONDS);
                        if (this.sentinelPool != null) break block20;
                        String response = HttpUtils.doGet((String)String.format(ConstUtils.REDIS_SENTINEL_URL, this.appId));
                        if (response == null || response.isEmpty()) {
                            logger.warn("get response from remote server error, appId: {}, continue...", (Object)this.appId);
                            continue;
                        }
                        JSONObject jsonObject = null;
                        try {
                            jsonObject = JSONObject.parseObject((String)response);
                        }
                        catch (Exception e) {
                            logger.error("heartbeat error, appId: {}. continue...", (Object)this.appId, (Object)e);
                        }
                        if (jsonObject == null) {
                            logger.error("get sentinel info for appId: {} error. continue...", (Object)this.appId);
                            continue;
                        }
                        int status = jsonObject.getIntValue("status");
                        String message = jsonObject.getString("message");
                        if (status == ClientStatusEnum.ERROR.getStatus()) {
                            throw new IllegalStateException(message);
                        }
                        if (status == ClientStatusEnum.WARN.getStatus()) {
                            logger.warn(message);
                        } else {
                            logger.info(message);
                        }
                        String masterName = jsonObject.getString("masterName");
                        String sentinels = jsonObject.getString("sentinels");
                        HashSet<String> sentinelSet = new HashSet<String>();
                        for (String sentinelStr : sentinels.split(" ")) {
                            String[] sentinelArr = sentinelStr.split(":");
                            if (sentinelArr.length != 2) continue;
                            sentinelSet.add(sentinelStr);
                        }
                        if (this.clientStatIsOpen) {
                            ClientDataCollectReportExecutor.getInstance();
                        }
                        this.sentinelPool = StringUtil.isBlank((String)(password = jsonObject.getString("password"))) ? new JedisSentinelPool(masterName, sentinelSet, this.poolConfig, this.connectionTimeout, this.soTimeout, null, 0) : new JedisSentinelPool(masterName, sentinelSet, this.poolConfig, this.connectionTimeout, this.soTimeout, password, 0);
                        JedisSentinelPool jedisSentinelPool = this.sentinelPool;
                        return jedisSentinelPool;
                    }
                    catch (Throwable e) {
                        logger.error("error in build, appId: {}", (Object)this.appId, (Object)e);
                    }
                    finally {
                        LOCK.unlock();
                        continue;
                    }
                }
                try {
                    TimeUnit.MILLISECONDS.sleep(200 + new Random().nextInt(1000));
                }
                catch (InterruptedException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return this.sentinelPool;
    }

    public RedisSentinelBuilder setPoolConfig(GenericObjectPoolConfig poolConfig) {
        this.poolConfig = poolConfig;
        return this;
    }

    public RedisSentinelBuilder setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public RedisSentinelBuilder setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
        return this;
    }

    public RedisSentinelBuilder setTimeout(int timeout) {
        this.connectionTimeout = timeout;
        this.soTimeout = timeout;
        return this;
    }

    public RedisSentinelBuilder setClientStatIsOpen(boolean clientStatIsOpen) {
        this.clientStatIsOpen = clientStatIsOpen;
        return this;
    }
}

