/*
 * Decompiled with CFR 0.152.
 */
package com.sohu.tv.builder;

import com.alibaba.fastjson.JSONObject;
import com.sohu.tv.cachecloud.client.basic.util.ConstUtils;
import com.sohu.tv.cachecloud.client.basic.util.HttpUtils;
import com.sohu.tv.cachecloud.client.basic.util.StringUtil;
import com.sohu.tv.cachecloud.client.jedis.stat.ClientDataCollectReportExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.JedisPool;

public class RedisStandaloneBuilder {
    private Logger logger = LoggerFactory.getLogger(RedisStandaloneBuilder.class);
    private static final Lock LOCK = new ReentrantLock();
    private volatile JedisPool jedisPool;
    private GenericObjectPoolConfig poolConfig;
    private final long appId = ConstUtils.APP_ID;
    private int timeout = 2000;
    private boolean clientStatIsOpen = true;

    RedisStandaloneBuilder() {
        this.poolConfig = new GenericObjectPoolConfig();
        this.poolConfig.setMaxTotal(24);
        this.poolConfig.setMaxIdle(16);
        this.poolConfig.setMinIdle(0);
        this.poolConfig.setJmxEnabled(true);
        this.poolConfig.setJmxNamePrefix("jedis-pool");
    }

    public JedisPool build() {
        if (this.jedisPool == null) {
            while (true) {
                try {
                    String password;
                    String[] instanceArr;
                    JSONObject jsonObject;
                    while (true) {
                        LOCK.tryLock(100L, TimeUnit.MILLISECONDS);
                        if (this.jedisPool != null) continue;
                        String response = HttpUtils.doGet((String)String.format(ConstUtils.REDIS_STANDALONE_URL, this.appId));
                        if (response == null || response.isEmpty()) {
                            this.logger.warn("cannot get response from server, appId={}. continue...", (Object)this.appId);
                            continue;
                        }
                        jsonObject = null;
                        try {
                            jsonObject = JSONObject.parseObject((String)response);
                        }
                        catch (Exception e) {
                            this.logger.error("read json from response error, appId: {}.", (Object)this.appId, (Object)e);
                        }
                        if (jsonObject == null) {
                            this.logger.warn("invalid response, appId: {}. continue...", (Object)this.appId);
                            continue;
                        }
                        String instance = jsonObject.getString("standalone");
                        instanceArr = instance.split(":");
                        if (instanceArr.length == 2) break;
                        this.logger.warn("instance info is invalid, instance: {}, appId: {}, continue...", (Object)instance, (Object)this.appId);
                    }
                    if (this.clientStatIsOpen) {
                        ClientDataCollectReportExecutor.getInstance();
                    }
                    this.jedisPool = StringUtil.isBlank((String)(password = jsonObject.getString("password"))) ? new JedisPool(this.poolConfig, instanceArr[0], Integer.valueOf(instanceArr[1]).intValue(), this.timeout) : new JedisPool(this.poolConfig, instanceArr[0], Integer.valueOf(instanceArr[1]).intValue(), this.timeout, password);
                    return this.jedisPool;
                }
                catch (InterruptedException e) {
                    this.logger.error("error in build().", (Throwable)e);
                    continue;
                }
                break;
            }
        }
        return this.jedisPool;
    }

    public RedisStandaloneBuilder setPoolConfig(GenericObjectPoolConfig poolConfig) {
        this.poolConfig = poolConfig;
        return this;
    }

    public RedisStandaloneBuilder setTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public RedisStandaloneBuilder setClientStatIsOpen(boolean clientStatIsOpen) {
        this.clientStatIsOpen = clientStatIsOpen;
        return this;
    }
}

