/*
 * Decompiled with CFR 0.152.
 */
package com.sohu.tv.cachecloud.client.jedis.stat;

import com.sohu.tv.cachecloud.client.basic.util.DateUtils;
import com.sohu.tv.cachecloud.client.basic.util.NamedThreadFactory;
import com.sohu.tv.cachecloud.client.basic.util.NetUtils;
import com.sohu.tv.cachecloud.client.jedis.stat.ClientReportDataCenter;
import com.sohu.tv.jedis.stat.constant.ClientReportConstant;
import com.sohu.tv.jedis.stat.data.UsefulDataCollector;
import com.sohu.tv.jedis.stat.enums.ClientCollectDataTypeEnum;
import com.sohu.tv.jedis.stat.enums.ClientExceptionType;
import com.sohu.tv.jedis.stat.model.ClientReportBean;
import com.sohu.tv.jedis.stat.model.CostTimeDetailStatKey;
import com.sohu.tv.jedis.stat.model.CostTimeDetailStatModel;
import com.sohu.tv.jedis.stat.model.ExceptionModel;
import com.sohu.tv.jedis.stat.model.ValueLengthModel;
import com.sohu.tv.jedis.stat.utils.AtomicLongMap;
import com.sohu.tv.jedis.stat.utils.NumberUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientDataCollectReportExecutor {
    private final Logger logger = LoggerFactory.getLogger(ClientDataCollectReportExecutor.class);
    private static String clientIp = NetUtils.getLocalHost();
    private final ScheduledExecutorService jedisDataCollectReportScheduledExecutor = Executors.newScheduledThreadPool(3, (ThreadFactory)new NamedThreadFactory("jedisDataCollectReportScheduledExecutor", true));
    private ScheduledFuture<?> jedisDataCollectReportScheduleFuture;
    private final int delay = 5;
    private final int fixCycle = 60;
    private static volatile ClientDataCollectReportExecutor jedisDataCollectAndReportExecutor;

    private ClientDataCollectReportExecutor() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ClientDataCollectReportExecutor getInstance() {
        if (jedisDataCollectAndReportExecutor != null) return jedisDataCollectAndReportExecutor;
        Class<ClientDataCollectReportExecutor> clazz = ClientDataCollectReportExecutor.class;
        synchronized (ClientDataCollectReportExecutor.class) {
            if (jedisDataCollectAndReportExecutor != null) return jedisDataCollectAndReportExecutor;
            jedisDataCollectAndReportExecutor = new ClientDataCollectReportExecutor();
            // ** MonitorExit[var0] (shouldn't be in output)
            return jedisDataCollectAndReportExecutor;
        }
    }

    public void init() {
        Thread clientDataCollectReportThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String currentMinuteStamp = ClientReportConstant.getCollectTimeSDf().format(new Date());
                    ClientDataCollectReportExecutor.this.collectReportAllData(currentMinuteStamp);
                }
                catch (Exception e) {
                    UsefulDataCollector.collectException((Exception)e, (String)"", (long)System.currentTimeMillis(), (ClientExceptionType)ClientExceptionType.CLIENT_EXCEPTION_TYPE);
                    ClientDataCollectReportExecutor.this.logger.error("ClientDataCollectReport thread message is" + e.getMessage(), (Throwable)e);
                }
            }
        });
        clientDataCollectReportThread.setDaemon(true);
        this.jedisDataCollectReportScheduleFuture = this.jedisDataCollectReportScheduledExecutor.scheduleWithFixedDelay(clientDataCollectReportThread, 5L, 60L, TimeUnit.SECONDS);
    }

    private void collectReportAllData(String currentMinuteStamp) {
        String lastMinute = this.getLastMinute(currentMinuteStamp);
        if (lastMinute == null || "".equals(lastMinute.trim())) {
            return;
        }
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        list.addAll(this.collectReportCostTimeData(lastMinute));
        list.addAll(this.collectReportValueDistriData(lastMinute));
        list.addAll(this.collectReportExceptionData(lastMinute));
        HashMap<String, Integer> otherInfo = new HashMap<String, Integer>(4, 1.0f);
        otherInfo.put("cost_map_size", UsefulDataCollector.getDataCostTimeMapAll().size());
        otherInfo.put("value_map_size", UsefulDataCollector.getDataValueLengthDistributeMapAll().size());
        otherInfo.put("exception_map_size", UsefulDataCollector.getDataExceptionMapAll().size());
        otherInfo.put("collection_map_size", UsefulDataCollector.getCollectionCostTimeMapAll().size());
        if (!list.isEmpty()) {
            ClientReportBean ccReportBean = new ClientReportBean(clientIp, NumberUtil.toLong((String)lastMinute), System.currentTimeMillis(), list, otherInfo);
            ClientReportDataCenter.reportData(ccReportBean);
        }
    }

    private List<Map<String, Object>> collectReportCostTimeData(String lastMinute) {
        try {
            Map map = UsefulDataCollector.getCostTimeLastMinute((String)lastMinute);
            if (map == null || map.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            for (Map.Entry entry : map.entrySet()) {
                CostTimeDetailStatKey costTimeDetailStatKey = (CostTimeDetailStatKey)entry.getKey();
                AtomicLongMap statMap = (AtomicLongMap)entry.getValue();
                CostTimeDetailStatModel model = UsefulDataCollector.generateCostTimeDetailStatKey((AtomicLongMap)statMap);
                HashMap<String, Object> tempMap = new HashMap<String, Object>();
                tempMap.put("cost_count", model.getTotalCount());
                tempMap.put("cost_command", costTimeDetailStatKey.getCommand());
                tempMap.put("cost_host_port", costTimeDetailStatKey.getHostPort());
                tempMap.put("cost_time_90_max", model.getNinetyPercentMax());
                tempMap.put("cost_time_99_max", model.getNinetyNinePercentMax());
                tempMap.put("cost_time_100_max", model.getHundredMax());
                tempMap.put("cost_time_mean", model.getMean());
                tempMap.put("cost_time_median", model.getMedian());
                tempMap.put("client_data_type", ClientCollectDataTypeEnum.COST_TIME_DISTRI_TYPE.getValue());
                list.add(tempMap);
            }
            return list;
        }
        catch (Exception e) {
            UsefulDataCollector.collectException((Exception)e, (String)"", (long)System.currentTimeMillis(), (ClientExceptionType)ClientExceptionType.CLIENT_EXCEPTION_TYPE);
            this.logger.error("collectReportCostTimeData:" + e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    private List<Map<String, Object>> collectReportExceptionData(String lastMinute) {
        try {
            Map map = UsefulDataCollector.getExceptionLastMinute((String)lastMinute);
            if (map == null || map.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            HashMap<String, Object> tempMap = null;
            for (Map.Entry entry : map.entrySet()) {
                ExceptionModel exceptionModel = (ExceptionModel)entry.getKey();
                Long exceptionCount = (Long)entry.getValue();
                tempMap = new HashMap<String, Object>();
                tempMap.put("exception_class", exceptionModel.getExceptionClass());
                tempMap.put("exception_msg", "");
                tempMap.put("exception_happen_time", System.currentTimeMillis());
                tempMap.put("exception_host_port", exceptionModel.getHostPort());
                tempMap.put("exception_count", exceptionCount);
                tempMap.put("exception_type", exceptionModel.getClientExceptionType().getType());
                tempMap.put("client_data_type", ClientCollectDataTypeEnum.EXCEPTION_TYPE.getValue());
                list.add(tempMap);
            }
            return list;
        }
        catch (Exception e) {
            UsefulDataCollector.collectException((Exception)e, (String)"", (long)System.currentTimeMillis(), (ClientExceptionType)ClientExceptionType.CLIENT_EXCEPTION_TYPE);
            this.logger.error("collectReportExceptionData:" + e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    private List<Map<String, Object>> collectReportValueDistriData(String lastMinute) {
        try {
            Map jedisValueLengthMap = UsefulDataCollector.getValueLengthLastMinute((String)lastMinute);
            if (jedisValueLengthMap == null || jedisValueLengthMap.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            for (Map.Entry entry : jedisValueLengthMap.entrySet()) {
                ValueLengthModel model = (ValueLengthModel)entry.getKey();
                Long count = (Long)entry.getValue();
                HashMap<String, Object> tempMap = new HashMap<String, Object>();
                tempMap.put("value_distri", model.getRedisValueSizeEnum().getValue());
                tempMap.put("value_count", count);
                tempMap.put("value_command", model.getCommand());
                tempMap.put("value_host_port", model.getHostPort());
                tempMap.put("client_data_type", ClientCollectDataTypeEnum.VALUE_LENGTH_DISTRI_TYPE.getValue());
                list.add(tempMap);
            }
            return list;
        }
        catch (Exception e) {
            UsefulDataCollector.collectException((Exception)e, (String)"", (long)System.currentTimeMillis(), (ClientExceptionType)ClientExceptionType.CLIENT_EXCEPTION_TYPE);
            this.logger.error("collectReportValueDistriData:" + e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    private String getLastMinute(String currentMinuteStamp) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            Date currentDate = sdf.parse(currentMinuteStamp);
            Date lastMinute = DateUtils.addMinutes((Date)currentDate, (int)-1);
            return sdf.format(lastMinute);
        }
        catch (ParseException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void close() {
        try {
            this.jedisDataCollectReportScheduleFuture.cancel(true);
        }
        catch (Throwable t) {
            this.logger.error(t.getMessage(), t);
        }
    }

    public static String getClientIp() {
        return clientIp;
    }
}

